/*
 * Decompiled with CFR 0.152.
 */
package org.sqlbuilder;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Properties;

public class SystemUtils {
    public static boolean isRunningFromRunnable() {
        try {
            Class.forName("org.eclipse.jdt.internal.jarinjarloader.JarRsrcLoader");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String classpath() {
        StringBuilder sb = new StringBuilder();
        String classPath = System.getProperty("java.class.path");
        String[] pathElements = classPath.split(File.pathSeparator);
        boolean first = true;
        for (String pathElement : pathElements) {
            if (first) {
                first = false;
            } else {
                sb.append('\n');
            }
            sb.append(String.format("[cp]  %s", pathElement));
        }
        return sb.toString();
    }

    public static String classpathFromClassLoader(URLClassLoader classLoader) {
        StringBuilder sb = new StringBuilder();
        URL[] urls = classLoader.getURLs();
        boolean first = true;
        for (URL url : urls) {
            if (first) {
                first = false;
            } else {
                sb.append('\n');
            }
            sb.append(String.format("[cp]  %s", url.getFile()));
        }
        return sb.toString();
    }

    public static String classpathFromClassLoader() {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        return SystemUtils.classpathFromClassLoader((URLClassLoader)classLoader);
    }

    public static String systemProperties() {
        StringBuilder sb = new StringBuilder();
        Properties props = System.getProperties();
        Object[] keys = props.stringPropertyNames().toArray(new String[0]);
        Arrays.sort(keys);
        for (Object key : keys) {
            String value = props.get(key).toString().replaceAll("\n", "<lf>").replaceAll("\r", "<cr>");
            sb.append(String.format("[sys] %s=%s%n", key, value));
        }
        return sb.toString();
    }

    public static String systemInfo() {
        return String.format("[mem] max=%s%n", Runtime.getRuntime().maxMemory()) + SystemUtils.systemProperties();
    }

    public static String all() {
        return String.format("[jij] running=%s%n", SystemUtils.isRunningFromRunnable()) + SystemUtils.classpath() + SystemUtils.systemInfo();
    }

    public static void main(String[] args) {
        System.out.println(SystemUtils.all());
    }
}

