/*
 * Decompiled with CFR 0.152.
 */
package org.sqlbuilder;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.EventReaderDelegate;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlValidate {
    public static OutputStream insertDTD(String dtdPath, String file, OutputStream os) throws XMLStreamException {
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        DTD dtdEvent = eventFactory.createDTD(String.format("<!DOCTYPE Employee SYSTEM \"%s\">", dtdPath));
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLEventReader reader = inputFactory.createXMLEventReader(new StreamSource(file));
        reader = new DTDReplacer(reader, dtdEvent);
        XMLEventWriter writer = outputFactory.createXMLEventWriter(os);
        writer.add(reader);
        writer.flush();
        return os;
    }

    public static OutputStream insertDTD2(String dtd, String file, OutputStream os) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("doctype-system", dtd);
        transformer.transform(new StreamSource(file), new StreamResult(System.out));
        return os;
    }

    public static void validateBuild(String dtd, String file) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setValidating(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException e) {
                e.printStackTrace();
            }

            @Override
            public void fatalError(SAXParseException e) {
                e.printStackTrace();
            }

            @Override
            public void warning(SAXParseException e) {
                e.printStackTrace();
            }
        });
        builder.parse(file);
    }

    public static void validate(String xsdPath, String file) throws SAXException, IOException {
        Validator validator = XmlValidate.makeValidator(xsdPath);
        System.out.println("validate " + file);
        validator.validate(new StreamSource(file));
    }

    public static void validate(Validator validator, String file) throws SAXException, IOException {
        validator.validate(new StreamSource(file));
    }

    public static Validator makeValidator(String xsdPath) throws SAXException {
        URL xsdUrl;
        try {
            xsdUrl = XmlValidate.class.getResource(xsdPath);
            if (xsdUrl == null) {
                throw new RuntimeException("Null XSD resource file");
            }
        }
        catch (Exception e) {
            try {
                xsdUrl = new URL(xsdPath);
            }
            catch (Exception e1) {
                try {
                    xsdUrl = new File(xsdPath).toURI().toURL();
                }
                catch (Exception e2) {
                    throw new RuntimeException("No validator XSD file");
                }
            }
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(xsdUrl);
        Validator validator = schema.newValidator();
        System.out.println("* validate from: " + xsdUrl);
        return validator;
    }

    public static void validateAll(String xsdPath, String ... files) throws SAXException {
        Validator validator = XmlValidate.makeValidator(xsdPath);
        for (String file : files) {
            System.out.print(file);
            try {
                XmlValidate.validate(validator, file);
                System.out.println(" ok");
            }
            catch (IOException | SAXException e) {
                System.err.println(e);
                System.out.println(" invalid");
            }
        }
    }

    public static void main(String[] args) throws SAXException {
        XmlValidate.validateAll(args[0], Arrays.copyOfRange(args, 1, args.length));
    }

    public static class DTDReplacer
    extends EventReaderDelegate {
        private final XMLEvent dtdEvent;
        private boolean sendDtd = false;

        public DTDReplacer(XMLEventReader reader, XMLEvent dtdEvent) {
            super(reader);
            if (dtdEvent.getEventType() != 11) {
                throw new IllegalArgumentException(dtdEvent.toString());
            }
            this.dtdEvent = dtdEvent;
        }

        @Override
        public XMLEvent nextEvent() throws XMLStreamException {
            if (this.sendDtd) {
                this.sendDtd = false;
                return this.dtdEvent;
            }
            XMLEvent event = super.nextEvent();
            if (event.getEventType() == 7) {
                this.sendDtd = true;
            } else if (event.getEventType() == 11) {
                return super.nextEvent();
            }
            return event;
        }
    }
}

