/*
 * Decompiled with CFR 0.152.
 */
package io.github.stepio.lambda.json;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.github.stepio.lambda.LambdaHandler;
import io.github.stepio.lambda.RequestContext;
import io.github.stepio.lambda.enums.MediaType;
import io.github.stepio.lambda.enums.Method;
import io.github.stepio.lambda.json.BodyRequestContext;
import io.github.stepio.lambda.util.Assert;
import io.github.stepio.lambda.util.Responses;
import io.github.stepio.lambda.util.StringUtils;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class DefaultLambdaHandler<B, R>
extends LambdaHandler {
    protected Class<B> bodyClass;
    protected Class<R> responseClass;
    protected ObjectMapper objectMapper;
    protected ConcurrentMap<Class<?>, ObjectReader> readers;
    protected ConcurrentMap<Class<?>, ObjectWriter> writers;

    public DefaultLambdaHandler() {
        Type[] array = this.genericTypes();
        if (array.length >= 2) {
            this.bodyClass = (Class)array[0];
            this.responseClass = (Class)array[1];
        }
        this.setObjectMapper(new ObjectMapper());
    }

    public DefaultLambdaHandler(Class<B> bodyClass, Class<R> responseClass) {
        this.bodyClass = bodyClass;
        this.responseClass = responseClass;
        this.setObjectMapper(new ObjectMapper());
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.readers = new ConcurrentHashMap();
        this.writers = new ConcurrentHashMap();
    }

    protected ObjectReader reader(Class<?> type) {
        return this.readers.computeIfAbsent(type, arg_0 -> ((ObjectMapper)this.objectMapper).readerFor(arg_0));
    }

    protected ObjectWriter writer(Class<?> type) {
        return this.writers.computeIfAbsent(type, arg_0 -> ((ObjectMapper)this.objectMapper).writerFor(arg_0));
    }

    public void registerCustom(Method method, Function<BodyRequestContext<B>, R> customHandler) {
        Function<RequestContext, APIGatewayProxyResponseEvent> handler = requestContext -> {
            BodyRequestContext<B> bodyRequestContext = new BodyRequestContext<B>(this.body(requestContext.getRequest()), requestContext.getRequest(), requestContext.getContext());
            Object response = customHandler.apply(bodyRequestContext);
            return this.wrap(response);
        };
        this.register(method, handler);
    }

    protected B body(APIGatewayProxyRequestEvent request) {
        String bodyText = request.getBody();
        if (StringUtils.isEmpty((Object)bodyText)) {
            return null;
        }
        Assert.notNull(this.bodyClass, (String)"Request class is mandatory", (Object[])new Object[0]);
        if (String.class == this.bodyClass) {
            return (B)bodyText;
        }
        ObjectReader reader = this.reader(this.bodyClass);
        try {
            return (B)reader.readValue(bodyText);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(Assert.message((String)"Failed to extract %s from request body %s", (Object[])new Object[]{this.bodyClass, bodyText}), ex);
        }
    }

    protected APIGatewayProxyResponseEvent wrap(R response) {
        if (StringUtils.isEmpty(response)) {
            return Responses.noContent();
        }
        Assert.notNull(this.responseClass, (String)"Response class is mandatory", (Object[])new Object[0]);
        if (String.class == this.responseClass) {
            return Responses.ok((MediaType)MediaType.TEXT_PLAIN, (String)((String)response));
        }
        ObjectWriter writer = this.writer(this.responseClass);
        try {
            String responseText = writer.writeValueAsString(response);
            return Responses.ok((MediaType)MediaType.APPLICATION_JSON_UTF8, (String)responseText);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException(Assert.message((String)"Failed to serialize %s", (Object[])new Object[]{response}), ex);
        }
    }

    protected Type[] genericTypes() {
        Type type = ((Object)((Object)this)).getClass().getGenericSuperclass();
        if (!(type instanceof ParameterizedType)) {
            return new Type[0];
        }
        Type[] array = ((ParameterizedType)type).getActualTypeArguments();
        if (array == null || array.length < 2) {
            return new Type[0];
        }
        return array;
    }
}

