/*
 * Decompiled with CFR 0.152.
 */
package io.github.therealmone.jtrAPI;

import io.github.therealmone.jtrAPI.Translator;
import io.github.therealmone.spoLexer.Lexer;
import io.github.therealmone.spoParser.Parser;
import io.github.therealmone.spoStackMachine.StackMachine;
import io.github.therealmone.translatorAPI.Exceptions.TranslatorException;
import io.github.therealmone.translatorAPI.Interfaces.ExceptionInterface;
import io.github.therealmone.translatorAPI.Interfaces.Visitor;
import io.github.therealmone.translatorAPI.ResourceLoader;
import io.github.therealmone.translatorAPI.SavePrinter;
import io.github.therealmone.translatorAPI.Token;
import java.util.HashSet;

class TranslatorImpl
implements Translator {
    private boolean devMode = false;

    TranslatorImpl() {
    }

    @Override
    public void translate(String program) {
        try {
            ResourceLoader.initialize();
            SavePrinter.savePrintln((String)"\u001b[31mMAIN PROGRAM\u001b[0m");
            SavePrinter.savePrintln((String)"-----------------------------------------------------------------------------------------");
            Lexer lexer = new Lexer();
            if (this.devMode) {
                lexer.showLexemes();
            }
            lexer.generateTokens(program);
            if (this.devMode) {
                lexer.showTokens();
            }
            Parser parser = new Parser(new HashSet(lexer.lexemes.keySet()));
            if (this.devMode) {
                parser.showLangRules();
            }
            for (Token token : lexer.tokens) {
                token.accept((Visitor)parser);
            }
            if (this.devMode) {
                SavePrinter.savePrintln((String)"\u001b[32mPARSE SUCCESS\u001b[0m");
                SavePrinter.savePrintln((String)("RPN: " + parser.getRPN()));
            }
            StackMachine stackMachine = new StackMachine();
            parser.accept((Visitor)stackMachine);
            SavePrinter.savePrintln((String)"-----------------------------------------------------------------------------------------");
            SavePrinter.savePrintln((String)"\u001b[31mMAIN PROGRAM DONE\u001b[0m");
            if (this.devMode) {
                SavePrinter.savePrintln((String)"\u001b[32mCALCULATE SUCCESS\u001b[0m");
                stackMachine.showVariables();
            }
        }
        catch (TranslatorException e) {
            if (this.devMode) {
                e.printStackTrace();
            }
            this.printError(e);
            SavePrinter.savePrintln((String)"-----------------------------------------------------------------------------------------");
            SavePrinter.savePrintln((String)"\u001b[31mMAIN PROGRAM FAILED\u001b[0m");
        }
    }

    @Override
    public void setDevMode(Boolean devMode) {
        this.devMode = devMode;
    }

    private void printError(TranslatorException e) {
        if (e instanceof ExceptionInterface) {
            ((ExceptionInterface)e).message();
        } else {
            SavePrinter.savePrintln((String)e.getMessage());
        }
    }
}

