/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.flow.assertions;

import com.tidal.flow.assertions.BaseAssertionTypes;
import com.tidal.flow.assertions.NullCheck;
import com.tidal.flow.assertions.stackbuilder.ErrorStack;

public abstract class BaseAssertion<T>
implements BaseAssertionTypes<T> {
    protected String description;
    protected T actual;
    protected boolean softAssertion;
    protected boolean status = true;
    protected static final String ACTUAL_TYPE_DESCRIPTION = "Actual, input value is";
    protected static final String EXPECTED_TYPE_DESCRIPTION = "Expected, input value is";

    @Override
    public void isEqualTo(T value) {
        if (NullCheck.assertNull(ACTUAL_TYPE_DESCRIPTION, this.actual, this.softAssertion) || NullCheck.assertNull(EXPECTED_TYPE_DESCRIPTION, value, this.softAssertion)) {
            return;
        }
        if (!this.actual.equals(value)) {
            this.status = false;
        }
        String errorDetail = String.format("Actual value '%s' is not equal to comparison value '%s'", this.actual, value);
        new ErrorStack.Builder(errorDetail, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
    }

    @Override
    public void isNotEqualTo(T value) {
        if (NullCheck.assertNull(ACTUAL_TYPE_DESCRIPTION, this.actual, this.softAssertion) || NullCheck.assertNull(EXPECTED_TYPE_DESCRIPTION, value, this.softAssertion)) {
            return;
        }
        if (this.actual.equals(value)) {
            this.status = false;
        }
        String errorDetail = String.format("Actual value '%s' should not be equal to comparison value '%s'", this.actual, value);
        new ErrorStack.Builder(errorDetail, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
    }

    @Override
    public void isNotNull() {
        if (NullCheck.assertNull(ACTUAL_TYPE_DESCRIPTION, this.actual, this.softAssertion)) {
            return;
        }
        if (this.actual == null) {
            this.status = false;
        }
        String errorDetail = "Actual value is a null value";
        new ErrorStack.Builder(errorDetail, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
    }

    @Override
    public void isInstanceOf(Class<?> klass) {
        if (NullCheck.assertNull(ACTUAL_TYPE_DESCRIPTION, this.actual, this.softAssertion) || NullCheck.assertNull(EXPECTED_TYPE_DESCRIPTION, klass, this.softAssertion)) {
            return;
        }
        if (klass != this.actual.getClass()) {
            this.status = false;
        }
        String errorDetail = String.format("Expected class type was '%s' but instead got '%s'", klass, this.actual.getClass());
        new ErrorStack.Builder(errorDetail, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
    }
}

