/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.flow.assertions.arrays;

import com.tidal.flow.assertions.NullCheck;
import com.tidal.flow.assertions.arrays.ArrayAssert;
import com.tidal.flow.assertions.stackbuilder.ErrorStack;
import java.util.Arrays;
import java.util.Objects;

public class ArrayAssertion<T>
extends ArrayAssert<T> {
    public ArrayAssertion(String description, T[] actual, boolean softAssertion) {
        this.description = description;
        this.actual = actual;
        this.softAssertion = softAssertion;
    }

    @Override
    @SafeVarargs
    public final ArrayAssert<T> contains(T ... values) {
        if (NullCheck.assertNull("Actual, input value is", (Object[])this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", values, this.softAssertion)) {
            return this;
        }
        Arrays.asList(values).forEach(v -> {
            this.status = Arrays.asList((Object[])this.actual).contains(v);
            String errorDetails = String.format("Value '%s' is not contained in array '%s'", v, Arrays.toString((Object[])this.actual));
            ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        });
        return this;
    }

    @Override
    @SafeVarargs
    public final ArrayAssert<T> notContains(T ... values) {
        if (NullCheck.assertNull("Actual, input value is", (Object[])this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", values, this.softAssertion)) {
            return this;
        }
        Arrays.asList(values).forEach(v -> {
            this.status = !Arrays.asList((Object[])this.actual).contains(v);
            String errorDetails = String.format("Value '%s' is contained or present in array '%s'", v, Arrays.toString((Object[])this.actual));
            ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        });
        return this;
    }

    @Override
    public ArrayAssert<T> hasSize(int size) {
        if (NullCheck.assertNull("Actual, input value is", (Object[])this.actual, this.softAssertion)) {
            return this;
        }
        if (((Object[])this.actual).length != size) {
            this.status = false;
        }
        String errorDetails = String.format("Array actual size %d is not equal to expected size %d", ((Object[])this.actual).length, size);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public ArrayAssert<T> isTypeOf(Class<?> klass) {
        if (NullCheck.assertNull("Actual, input value is", (Object[])this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", klass, this.softAssertion)) {
            return this;
        }
        if (((Object[])this.actual)[0].getClass() != klass) {
            this.status = false;
        }
        String errorDetails = String.format("Array expected type was '%s' but it was '%s'", klass, ((Object[])this.actual)[0].getClass());
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public ArrayAssert<T> isEmpty() {
        if (NullCheck.assertNull("Actual, input value is", (Object[])this.actual, this.softAssertion)) {
            return this;
        }
        if (((Object[])this.actual).length != 0 && !Arrays.stream((Object[])this.actual).allMatch(Objects::isNull)) {
            this.status = false;
        }
        String errorDetails = String.format("Array expected to be empty, but it size was %d", ((Object[])this.actual).length);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public ArrayAssert<T> isNotEmpty() {
        if (NullCheck.assertNull("Actual, input value is", (Object[])this.actual, this.softAssertion)) {
            return this;
        }
        if (((Object[])this.actual).length == 0 || !Arrays.stream((Object[])this.actual).allMatch(Objects::isNull)) {
            this.status = false;
        }
        String errorDetails = String.format("Input array '%s' is supposed not to be empty", Arrays.toString((Object[])this.actual));
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }
}

