/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.flow.assertions.dates;

import com.tidal.flow.assertions.NullCheck;
import com.tidal.flow.assertions.dates.DateAssert;
import com.tidal.flow.assertions.stackbuilder.ErrorStack;
import java.time.Instant;
import java.util.Date;

public class DateAssertion
extends DateAssert<Date> {
    public DateAssertion(String description, Date actual, boolean softAssertion) {
        this.description = description;
        this.actual = actual;
        this.softAssertion = softAssertion;
    }

    @Override
    public DateAssert<Date> isInTheFuture() {
        if (NullCheck.assertNull("Actual, input value is", (Date)this.actual, this.softAssertion)) {
            return this;
        }
        if (((Date)this.actual).before(Date.from(Instant.now()))) {
            this.status = false;
        }
        String errorDetails = String.format("Date '%s' is not a future date", this.actual);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public DateAssert<Date> isInThePast() {
        if (NullCheck.assertNull("Actual, input value is", (Date)this.actual, this.softAssertion)) {
            return this;
        }
        if (((Date)this.actual).after(Date.from(Instant.now()))) {
            this.status = false;
        }
        String errorDetails = String.format("Date '%s' is not a date in the past", this.actual);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public DateAssert<Date> isBefore(Date value) {
        if (NullCheck.assertNull("Actual, input value is", (Date)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", value, this.softAssertion)) {
            return this;
        }
        if (!((Date)this.actual).before(value)) {
            this.status = false;
        }
        String errorDetails = String.format("Date '%s' is not after date '%s'", this.actual, value);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public DateAssert<Date> isAfter(Date value) {
        if (NullCheck.assertNull("Actual, input value is", (Date)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", value, this.softAssertion)) {
            return this;
        }
        if (!((Date)this.actual).after(value)) {
            this.status = false;
        }
        String errorDetails = String.format("Date '%s' is not after date '%s'", this.actual, value);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }
}

