/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.flow.assertions.lists;

import com.tidal.flow.assertions.NullCheck;
import com.tidal.flow.assertions.lists.ListAssert;
import com.tidal.flow.assertions.stackbuilder.ErrorStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ListAssertion<T>
extends ListAssert<T> {
    public ListAssertion(String description, List<T> actual, boolean softAssertion) {
        this.description = description;
        this.actual = actual;
        this.softAssertion = softAssertion;
    }

    @Override
    @SafeVarargs
    public final ListAssert<T> contains(T ... values) {
        if (NullCheck.assertNull("Actual, input value is", (List)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", values, this.softAssertion)) {
            return this;
        }
        Arrays.stream(values).forEach(e -> {
            this.status = ((List)this.actual).contains(e);
            String errorDetail = String.format("Element '%s' not in the list %s", e, this.actual);
            new ErrorStack.Builder(errorDetail, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        });
        return this;
    }

    @Override
    public ListAssert<T> containsList(List<T> value) {
        if (NullCheck.assertNull("Actual, input value is", (List)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", value, this.softAssertion)) {
            return this;
        }
        value.forEach(v -> {
            this.status = ((List)this.actual).contains(v);
            String errorDetail = String.format("List '%s' does not contain element '%s' from list '%s'", this.actual, v, value);
            new ErrorStack.Builder(errorDetail, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        });
        return this;
    }

    @Override
    @SafeVarargs
    public final ListAssert<T> notContains(T ... values) {
        if (NullCheck.assertNull("Actual, input value is", (List)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", values, this.softAssertion)) {
            return this;
        }
        Arrays.stream(values).forEach(e -> {
            if (((List)this.actual).contains(e)) {
                this.status = false;
            }
            String errorDetail = String.format("Element '%s' is contained in the list %s", e, this.actual);
            new ErrorStack.Builder(errorDetail, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        });
        return this;
    }

    @Override
    public ListAssert<T> isEmpty() {
        if (NullCheck.assertNull("Actual, input value is", (List)this.actual, this.softAssertion)) {
            return this;
        }
        if (!((List)this.actual).isEmpty()) {
            this.status = false;
        }
        String errorDetail = String.format("List '%s' is not empty", this.actual);
        new ErrorStack.Builder(errorDetail, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public ListAssert<T> isNotEmpty() {
        if (NullCheck.assertNull("Actual, input value is", (List)this.actual, this.softAssertion)) {
            return this;
        }
        if (((List)this.actual).isEmpty()) {
            this.status = false;
        }
        String errorDetail = String.format("List '%s' is empty", this.actual);
        new ErrorStack.Builder(errorDetail, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public ListAssert<T> ofType(Class<?> value) {
        if (NullCheck.assertNull("Actual, input value is", (List)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", value, this.softAssertion)) {
            return this;
        }
        if (((List)this.actual).get(0).getClass() != value) {
            this.status = false;
        }
        String errorDetail = String.format("The list '%s' and '%s' are not of the same type'", ((List)this.actual).get(0).getClass(), value);
        new ErrorStack.Builder(errorDetail, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public final ListAssert<T> hasSize(int value) {
        if (NullCheck.assertNull("Actual, input value is", (List)this.actual, this.softAssertion)) {
            return this;
        }
        if (((List)this.actual).size() != value) {
            this.status = false;
        }
        String errorDetail = String.format("Expected size of the list is '%d' but was '%d'", value, ((List)this.actual).size());
        new ErrorStack.Builder(errorDetail, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public final ListAssert<T> hasSizeGreaterThan(int value) {
        if (NullCheck.assertNull("Actual, input value is", (List)this.actual, this.softAssertion)) {
            return this;
        }
        if (((List)this.actual).size() <= value) {
            this.status = false;
        }
        String errorDetail = String.format("List size expected to be greater than '%d' but was '%d'", value, ((List)this.actual).size());
        new ErrorStack.Builder(errorDetail, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public final ListAssert<T> hasSizeLessThan(int value) {
        if (NullCheck.assertNull("Actual, input value is", (List)this.actual, this.softAssertion)) {
            return this;
        }
        if (((List)this.actual).size() <= value) {
            this.status = false;
        }
        String errorDetail = String.format("List size expected to be less than '%d' but was '%d'", value, ((List)this.actual).size());
        new ErrorStack.Builder(errorDetail, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public ListAssert<T> isSubListOf(List<T> value) {
        if (NullCheck.assertNull("Actual, input value is", (List)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", value, this.softAssertion)) {
            return this;
        }
        if (Collections.indexOfSubList(value, (List)this.actual) == -1) {
            this.status = false;
        }
        String errorDetail = String.format("List '%s' expected to be a sublist of '%s''", this.actual, value);
        new ErrorStack.Builder(errorDetail, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public ListAssert<T> isSuperListOf(List<T> value) {
        if (NullCheck.assertNull("Actual, input value is", (List)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", value, this.softAssertion)) {
            return this;
        }
        if (Collections.indexOfSubList((List)this.actual, value) == -1) {
            this.status = false;
        }
        String errorDetail = String.format("List '%s' expected to be a super list of '%s''", this.actual, value);
        new ErrorStack.Builder(errorDetail, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }
}

