/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.flow.assertions.numbers;

import com.tidal.flow.assertions.NullCheck;
import com.tidal.flow.assertions.numbers.NumberAssert;
import com.tidal.flow.assertions.stackbuilder.ErrorStack;

public class NumberAssertion
extends NumberAssert<Number> {
    public NumberAssertion(String description, Number actual, boolean softAssertion) {
        this.description = description;
        this.actual = actual;
        this.softAssertion = softAssertion;
    }

    @Override
    public NumberAssert<Number> isGreaterThan(Number value) {
        if (NullCheck.assertNull("Actual, input value is", (Number)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", value, this.softAssertion)) {
            return this;
        }
        if (((Number)this.actual).doubleValue() <= value.doubleValue()) {
            this.status = false;
        }
        String errorDetails = String.format("Actual value '%s' is not great than the comparison value '%s", this.actual, value);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public NumberAssert<Number> isLessThan(Number value) {
        if (NullCheck.assertNull("Actual, input value is", (Number)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", value, this.softAssertion)) {
            return this;
        }
        if (((Number)this.actual).doubleValue() >= value.doubleValue()) {
            this.status = false;
        }
        String errorDetails = String.format("Actual value '%s' is not less than the comparison value '%s'", this.actual, value);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public NumberAssert<Number> isPositive() {
        if (NullCheck.assertNull("Actual, input value is", (Number)this.actual, this.softAssertion)) {
            return this;
        }
        if (((Number)this.actual).doubleValue() < 0.0) {
            this.status = false;
        }
        String errorDetails = String.format("Value '%s' is not a positive value", this.actual);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public NumberAssert<Number> isNegative() {
        if (NullCheck.assertNull("Actual, input value is", (Number)this.actual, this.softAssertion)) {
            return this;
        }
        if (((Number)this.actual).doubleValue() >= 0.0) {
            this.status = false;
        }
        String errorDetails = String.format("Value '%s' is not a negative value", this.actual);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }

    @Override
    public NumberAssert<Number> isInRangeOf(Number value1, Number value2) {
        if (NullCheck.assertNull("Actual, input value is", (Number)this.actual, this.softAssertion) || NullCheck.assertNull("Expected, input value is", value1, this.softAssertion) || NullCheck.assertNull("Expected, input value is", value2, this.softAssertion)) {
            return this;
        }
        if (value1.doubleValue() < value2.doubleValue() && (((Number)this.actual).doubleValue() < value1.doubleValue() || ((Number)this.actual).doubleValue() > value2.doubleValue())) {
            this.status = false;
        }
        if (value1.doubleValue() > value2.doubleValue() && (((Number)this.actual).doubleValue() > value1.doubleValue() || ((Number)this.actual).doubleValue() < value2.doubleValue())) {
            this.status = false;
        }
        String errorDetails = String.format("Value %s is not in range or between %s and %s", this.actual, value1, value2);
        ErrorStack.builder(errorDetails, this.description).withStackTrace(Thread.currentThread().getStackTrace()).withAssertionStatus(this.softAssertion, this.status).build();
        return this;
    }
}

