/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.flow.assertions.stackbuilder;

import com.tidal.flow.data.ExceptionData;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class ErrorStack {
    private String errorDetail;
    private StackTraceElement[] stackTrace;
    private boolean softAssertion;
    private boolean passed;
    private static final String PASS_KEY = "_pass";
    private static final ThreadLocal<Builder> builder = ThreadLocal.withInitial(Builder::new);

    public static Builder builder(String errorDetail, String description) {
        return builder.get().withErrorDetails(errorDetail + "\nDescription: " + description);
    }

    public void execute() {
        try {
            StringBuilder errorMessage = this.getErrorMessage(ExceptionData.getExceptionDataMap());
            if (errorMessage.length() > 0) {
                throw new AssertionError((Object)(System.lineSeparator() + errorMessage));
            }
        }
        finally {
            builder.remove();
            ExceptionData.removeExceptionData();
        }
    }

    private void runSoftAssertion() {
        if (this.softAssertion) {
            String randomId = UUID.randomUUID().toString();
            if (!this.passed) {
                ExceptionData.addExceptionData(randomId + "_d", this.errorDetail);
                ExceptionData.addExceptionData(randomId, this.stackTrace);
            }
        }
    }

    private void runHardAssertion() {
        if (!this.softAssertion) {
            String randomId = UUID.randomUUID().toString();
            if (!this.passed) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append(System.lineSeparator());
                errorMessage.append("Verification Failed: ");
                errorMessage.append(System.lineSeparator());
                errorMessage.append("Reason: ").append(this.errorDetail);
                errorMessage.append(System.lineSeparator());
                AtomicReference<AtomicInteger> i = new AtomicReference<AtomicInteger>(new AtomicInteger());
                AtomicInteger stackBuilderNumber = this.getStackBuilderNumber(this.stackTrace);
                Arrays.stream(this.stackTrace).forEach(e -> {
                    if (((AtomicInteger)i.get()).get() > stackBuilderNumber.get()) {
                        return;
                    }
                    if (((AtomicInteger)i.get()).get() <= stackBuilderNumber.get() && !e.toString().contains("getStackTrace")) {
                        errorMessage.append("at ");
                        errorMessage.append(e);
                        errorMessage.append(System.lineSeparator());
                    }
                    ((AtomicInteger)i.get()).getAndIncrement();
                });
                throw new AssertionError((Object)errorMessage.toString());
            }
        }
    }

    private StringBuilder getErrorMessage(Map<String, Object> errorData) {
        StringBuilder errorMessage = new StringBuilder();
        AtomicReference<AtomicInteger> i = new AtomicReference<AtomicInteger>(new AtomicInteger());
        errorData.forEach((k, v) -> {
            if (v instanceof StackTraceElement[]) {
                AtomicInteger stackBuilderNumber = this.getStackBuilderNumber((StackTraceElement[])v);
                errorMessage.append(System.lineSeparator());
                errorMessage.append("Verification Failed: ");
                errorMessage.append(ExceptionData.getExceptionData(k + "_d"));
                errorMessage.append(System.lineSeparator());
                Arrays.stream((StackTraceElement[])v).forEach(e -> {
                    if (((AtomicInteger)i.get()).get() > stackBuilderNumber.get()) {
                        return;
                    }
                    if (((AtomicInteger)i.get()).get() <= stackBuilderNumber.get() && !e.toString().contains("getStackTrace")) {
                        errorMessage.append("at ");
                        errorMessage.append(e);
                        errorMessage.append(System.lineSeparator());
                    }
                    ((AtomicInteger)i.get()).getAndIncrement();
                });
                i.set(new AtomicInteger());
            }
        });
        return errorMessage;
    }

    private AtomicInteger getStackBuilderNumber(StackTraceElement[] stackTrace) {
        AtomicInteger stackBuilderNumber = new AtomicInteger(0);
        for (StackTraceElement e : stackTrace) {
            if (e.toString().contains("NativeMethodAccessorImpl.invoke0")) {
                stackBuilderNumber.decrementAndGet();
                break;
            }
            stackBuilderNumber.getAndIncrement();
        }
        return stackBuilderNumber;
    }

    private static StringBuilder getPassedMessages(Map<String, Object> verificationData) {
        StringBuilder passMessage = new StringBuilder();
        verificationData.forEach((k, v) -> {
            if (k.contains(PASS_KEY)) {
                passMessage.append(System.lineSeparator());
                passMessage.append("Verification Passed: ");
                passMessage.append(ExceptionData.getExceptionData(k));
            }
        });
        return passMessage;
    }

    static /* synthetic */ StackTraceElement[] access$102(ErrorStack x0, StackTraceElement[] x1) {
        x0.stackTrace = x1;
        return x1;
    }

    public static class Builder {
        private String errorDetail;
        private StackTraceElement[] stackTrace;
        private boolean softAssertion;
        private boolean passed;

        public Builder() {
        }

        public Builder(String errorDetail, String description) {
            this.errorDetail = errorDetail + "\nDescription: " + description;
        }

        public Builder withErrorDetails(String errorDetail) {
            this.errorDetail = errorDetail;
            return this;
        }

        public Builder withStackTrace(StackTraceElement[] stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        public Builder withAssertionStatus(boolean softAssertion, boolean passed) {
            this.softAssertion = softAssertion;
            this.passed = passed;
            return this;
        }

        public void build() {
            ErrorStack errorStack = new ErrorStack();
            errorStack.errorDetail = this.errorDetail;
            ErrorStack.access$102(errorStack, this.stackTrace);
            errorStack.softAssertion = this.softAssertion;
            errorStack.passed = this.passed;
            errorStack.runSoftAssertion();
            errorStack.runHardAssertion();
        }
    }
}

