/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.stream.azure.testresults;

import com.tidal.stream.azure.testresults.AdoResultReader;
import com.tidal.stream.httpRequest.ReqType;
import com.tidal.stream.httpRequest.Request;
import com.tidal.utils.filehandlers.FileReader;
import com.tidal.utils.json.JsonWriter;
import com.tidal.utils.propertieshandler.PropertiesFinder;
import java.util.Base64;
import java.util.function.UnaryOperator;

public class AdoTestResultUpdates {
    public static void updateTestResult(String scenarioName, Results results) {
        UnaryOperator getProperty = PropertiesFinder::getProperty;
        Request.set((String)getProperty.apply("ado.testpoints"));
        String authorization = "Basic " + Base64.getEncoder().encodeToString((":" + (String)getProperty.apply("ado.auth")).getBytes());
        Request.setMediaType("text/plain");
        Request.setHeader("Authorization", authorization);
        Request.setPayload("");
        Request.send(ReqType.GET);
        String result = Request.getResponseString();
        int testPointId = AdoResultReader.getRunId(scenarioName, result);
        Request.reset();
        String testUpdateUrl = (String)getProperty.apply("ado.testresults");
        String updatedUrlWithTestPointId = testUpdateUrl.replace("{testpoint}", String.valueOf(testPointId));
        Request.set(updatedUrlWithTestPointId);
        Request.setMediaType("application/json");
        Request.setHeader("Authorization", authorization);
        String payload = FileReader.readFileToString((String)"test-result.json");
        int testRunId = AdoResultReader.getLastResultId(scenarioName, result);
        String updatedPayload = payload.replace("{status}", results.getValue());
        updatedPayload = new JsonWriter("$[0].id", updatedPayload).setValue((Object)testRunId).extract();
        Request.setPayload(updatedPayload);
        Request.send(ReqType.PATCH);
    }

    public static enum Results {
        PASSED("Passed"),
        FAILED("Failed");

        final String value;

        private Results(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

