/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.stream.azure.testresults;

import com.tidal.stream.azure.AppConstants;
import com.tidal.stream.httpRequest.ReqType;
import com.tidal.stream.httpRequest.Request;
import com.tidal.utils.json.JsonReader;
import com.tidal.utils.propertieshandler.PropertiesFinder;
import java.util.ArrayList;
import java.util.function.UnaryOperator;
import net.minidev.json.JSONArray;

public class TestPoints {
    public int[] testPointIds(String[] tests) {
        return this.getTestPointsFromAzure(tests);
    }

    private int[] getTestPointsFromAzure(String[] tests) {
        UnaryOperator getProperty = PropertiesFinder::getProperty;
        Request.set((String)getProperty.apply("ado.testpoints"));
        String authorization = AppConstants.AZURE_AUTHORIZATION.get();
        Request.setMediaType("text/plain");
        Request.setHeader("Authorization", authorization);
        Request.send(ReqType.GET);
        String result = Request.getResponseString();
        Request.reset();
        return this.extractTestPoints(result, tests);
    }

    private int[] extractTestPoints(String azureResponse, String[] tests) {
        JSONArray testCases = (JSONArray)JsonReader.readValue((String)"value[*].testCase.name", (String)azureResponse);
        ArrayList<Integer> testPoints = new ArrayList<Integer>();
        for (String test : tests) {
            for (int i1 = 0; i1 < testCases.size(); ++i1) {
                if (!test.equals(testCases.get(i1))) continue;
                int testPointId = (Integer)JsonReader.readValue((String)("value[" + i1 + "].id"), (String)azureResponse);
                testPoints.add(testPointId);
            }
        }
        return testPoints.stream().mapToInt(Integer::intValue).toArray();
    }
}

