/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.stream.db;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.tidal.utils.propertieshandler.PropertiesFinder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;

public class AwsDynamoDb {
    private String accessKey;
    private String secretKey;
    private String region;
    private String tableName;
    private Map<String, String> partitionKeySet;
    private Map<String, String> sortKeySet;

    private AwsDynamoDb() {
    }

    public Optional<String> getItem(String key) {
        return this.getDbItem().isPresent() ? Optional.of(this.getDbItem().get().get(key).getS()) : Optional.empty();
    }

    public Optional<Map<String, String>> getItems() {
        HashMap items = new HashMap();
        if (this.getDbItem().isPresent()) {
            this.getDbItem().get().forEach((k, v) -> items.put(k, v.getS()));
            return Optional.of(items);
        }
        return Optional.empty();
    }

    private AmazonDynamoDB clientBuilder() {
        return (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withRegion(this.region)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.accessKey, this.secretKey)))).build();
    }

    private Optional<Map<String, AttributeValue>> getDbItem() {
        Map.Entry<String, String> partitionEntry = this.partitionKeySet.entrySet().iterator().next();
        Map.Entry<String, String> sortEntry = this.sortKeySet.entrySet().iterator().next();
        GetItemRequest request = new GetItemRequest().withTableName(this.tableName).addKeyEntry(partitionEntry.getKey(), new AttributeValue().withS(partitionEntry.getValue())).addKeyEntry(sortEntry.getKey(), new AttributeValue().withS(sortEntry.getValue()));
        GetItemResult result = this.clientBuilder().getItem(request);
        if (!result.toString().equals("{}")) {
            return Optional.of(result.getItem());
        }
        return Optional.empty();
    }

    public static class Finder {
        private static final String PARTITION_KEY_DEFAULT = "businessdomain";
        private static final String PARTITION_VALUE_DEFAULT = "ION:Default";
        private static final String SORT_KEY_DEFAULT = "id";
        private static final String TABLE_NAME_DEFAULT = "ddb_ErrorAlerts";
        UnaryOperator<String> getProperty = PropertiesFinder::getProperty;
        private final String accessKey = (String)this.getProperty.apply("aws.api.accessKey");
        private final String secretKey = (String)this.getProperty.apply("aws.api.secretKey");
        private final String region = (String)this.getProperty.apply("aws.s3.region");
        private String tableName;
        private Map<String, String> partitionKeySet;
        private Map<String, String> sortKeySet;

        public Finder fromTable(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Finder withSortKeySet(String key, String value) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(key, value);
            this.sortKeySet = map;
            return this;
        }

        public Finder withSortValue(String value) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(SORT_KEY_DEFAULT, value);
            this.sortKeySet = map;
            return this;
        }

        public Finder withPartitionKeySet(String key, String value) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(key, value);
            this.partitionKeySet = map;
            return this;
        }

        private Map<String, String> withDefaultPartitionKeySet() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(PARTITION_KEY_DEFAULT, PARTITION_VALUE_DEFAULT);
            return map;
        }

        public AwsDynamoDb find() {
            AwsDynamoDb awsDynamoDb = new AwsDynamoDb();
            awsDynamoDb.accessKey = this.accessKey;
            awsDynamoDb.secretKey = this.secretKey;
            awsDynamoDb.region = this.region;
            awsDynamoDb.tableName = this.tableName == null ? TABLE_NAME_DEFAULT : this.tableName;
            awsDynamoDb.partitionKeySet = this.partitionKeySet == null ? this.withDefaultPartitionKeySet() : this.partitionKeySet;
            awsDynamoDb.sortKeySet = this.sortKeySet;
            return awsDynamoDb;
        }
    }
}

