/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.stream.httpRequest;

import com.tidal.stream.exceptions.RuntimeTestException;
import com.tidal.stream.httpRequest.DataEnum;
import com.tidal.stream.httpRequest.ReqType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Request {
    private static final String BASE_URI = "baseURI";
    private static final String MEDIA_TYPE = "mediaType";
    private static final String PAYLOAD = "payload";
    private static final String RESPONSE_STRING = "responseString";
    private static final String QUERY_PARAM_ONE_KEY = "queryParamOneKey";
    private static final String QUERY_PARAM_TWO_KEY = "queryParamTwoKey";
    private static final ThreadLocal<OkHttpClient> CLIENT = new ThreadLocal();
    private static final ThreadLocal<Response> RESPONSE = new ThreadLocal();
    private static final ThreadLocal<okhttp3.Request> HTTP_REQUEST = new ThreadLocal();
    private static final ThreadLocal<HashMap<String, Object>> DATA_MAP = new ThreadLocal();
    private static final ThreadLocal<Map<String, Object>> HEADER_MAP = new ThreadLocal();
    private static final ThreadLocal<Headers> REQUEST_HEADERS = new ThreadLocal();

    private Request() {
    }

    public static void setHttpRequest(okhttp3.Request builtRequest) {
        HTTP_REQUEST.set(builtRequest);
    }

    public static void set() {
        CLIENT.set(new OkHttpClient().newBuilder().build());
        Request.createMap();
    }

    public static void set(String baseUri) {
        if (CLIENT.get() == null) {
            CLIENT.set(new OkHttpClient().newBuilder().build());
        }
        Request.createMap();
        DATA_MAP.get().put(BASE_URI, baseUri);
    }

    public static void setBaseUri(String baseUri) {
        if (DATA_MAP.get() == null) {
            Request.createMap();
        }
        DATA_MAP.get().put(BASE_URI, baseUri);
    }

    public static void setMediaType(String mediaType) {
        DATA_MAP.get().put(MEDIA_TYPE, mediaType);
    }

    public static void reset() {
        CLIENT.remove();
        DATA_MAP.remove();
        HEADER_MAP.remove();
        HTTP_REQUEST.remove();
        RESPONSE.remove();
        REQUEST_HEADERS.remove();
        CLIENT.set(new OkHttpClient().newBuilder().build());
    }

    public static void setHeader(String key, Object value) {
        HEADER_MAP.get().put(key, value);
    }

    public static void setQueryParams(String key, Object value) {
        if (DATA_MAP.get().get(QUERY_PARAM_ONE_KEY) == null) {
            DATA_MAP.get().put(QUERY_PARAM_ONE_KEY, key);
            DATA_MAP.get().put("queryParamOneValue", value);
        } else if (DATA_MAP.get().get(QUERY_PARAM_TWO_KEY) == null) {
            DATA_MAP.get().put(QUERY_PARAM_TWO_KEY, key);
            DATA_MAP.get().put("queryParamTwoValue", value);
        }
    }

    public static void setPayload(String payload) {
        DATA_MAP.get().put(PAYLOAD, payload);
    }

    public static <T> void setData(String key, T value) {
        DATA_MAP.get().put(key, value);
    }

    public static <T> void setData(DataEnum data, T value) {
        Request.createMap();
        DATA_MAP.get().put(data.getValue(), value);
    }

    public static <T> T getData(String key) {
        return (T)DATA_MAP.get().get(key);
    }

    public static <T> Optional<T> getData(DataEnum data) {
        Object value;
        if (DATA_MAP.get() == null) {
            Request.set();
        }
        if ((value = DATA_MAP.get().get(data.getValue())) == null) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static void send(ReqType reqType) {
        MediaType mediaType = MediaType.parse((String)"application/json");
        if ((String)DATA_MAP.get().get(MEDIA_TYPE) != null) {
            mediaType = MediaType.parse((String)((String)DATA_MAP.get().get(MEDIA_TYPE)));
        }
        RequestBody body = RequestBody.create((String)"", (MediaType)mediaType);
        if ((String)DATA_MAP.get().get(PAYLOAD) != null) {
            body = RequestBody.create((String)((String)DATA_MAP.get().get(PAYLOAD)), (MediaType)mediaType);
        }
        Request.applyHeaders();
        if (HTTP_REQUEST.get() == null) {
            Request.Builder requestBuilder = new Request.Builder().url(Request.queryBuilder().build());
            switch (reqType) {
                case GET: {
                    HTTP_REQUEST.set(requestBuilder.get().headers(REQUEST_HEADERS.get()).build());
                    break;
                }
                case DELETE: {
                    HTTP_REQUEST.set(requestBuilder.delete().headers(REQUEST_HEADERS.get()).build());
                    break;
                }
                default: {
                    HTTP_REQUEST.set(requestBuilder.method(reqType.getReqType().toUpperCase(Locale.ROOT), body).headers(REQUEST_HEADERS.get()).build());
                }
            }
        }
        try {
            RESPONSE.set(CLIENT.get().newCall(HTTP_REQUEST.get()).execute());
        }
        catch (IOException e) {
            throw new RuntimeTestException("IOException with request" + e.getMessage());
        }
    }

    private static HttpUrl.Builder queryBuilder() {
        HttpUrl.Builder builder = HttpUrl.get((String)((String)DATA_MAP.get().get(BASE_URI))).newBuilder();
        if (DATA_MAP.get().get(QUERY_PARAM_ONE_KEY) != null) {
            builder.addQueryParameter((String)DATA_MAP.get().get(QUERY_PARAM_ONE_KEY), (String)DATA_MAP.get().get("queryParamOneValue"));
        }
        if (DATA_MAP.get().get(QUERY_PARAM_TWO_KEY) != null) {
            builder.addQueryParameter((String)DATA_MAP.get().get(QUERY_PARAM_TWO_KEY), (String)DATA_MAP.get().get("queryParamTwoValue"));
        }
        return builder;
    }

    private static void applyHeaders() {
        Headers.Builder headerBuilder = new Headers.Builder();
        for (String key : HEADER_MAP.get().keySet()) {
            headerBuilder.add(key, (String)Objects.requireNonNull(HEADER_MAP.get().get(key)));
        }
        REQUEST_HEADERS.set(headerBuilder.build());
    }

    public static Response response() {
        if (RESPONSE.get() == null) {
            throw new RuntimeTestException("Response is null : Check if the request is sent");
        }
        return RESPONSE.get();
    }

    public static int getStatusCode() {
        if (RESPONSE.get() == null) {
            throw new RuntimeTestException("Status code is null : Check if the request is sent");
        }
        return RESPONSE.get().code();
    }

    public static String getResponseString() {
        if (RESPONSE.get() == null) {
            throw new RuntimeTestException("Response string is null : Check if the request is sent");
        }
        try {
            if (DATA_MAP.get().get(RESPONSE_STRING) == null) {
                DATA_MAP.get().put(RESPONSE_STRING, RESPONSE.get().body().string());
            }
            return (String)DATA_MAP.get().get(RESPONSE_STRING);
        }
        catch (IOException e) {
            throw new RuntimeTestException("IO Exception with response: " + e.getMessage());
        }
    }

    private static void createMap() {
        if (DATA_MAP.get() == null) {
            DATA_MAP.set(new HashMap());
        }
        if (HEADER_MAP.get() == null) {
            HEADER_MAP.set(new HashMap());
        }
    }
}

