/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.stream.mockserver;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;

public class MockServer {
    private WireMockServer wiremockServer;
    private String response;
    private int port;
    private String contentType;

    public MockServer withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public MockServer withPort(int port) {
        this.port = port;
        return this;
    }

    public MockServer shouldRespondWith(String response) {
        this.response = response;
        return this;
    }

    public void postMockRequest() {
        this.wiremockServer = new WireMockServer((Options)WireMockConfiguration.options().port(this.port));
        this.wiremockServer.start();
        this.wiremockServer.stubFor(WireMock.post((UrlPattern)WireMock.urlPathMatching((String)"/response/.*")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{this.contentType}).withBody(this.response)));
    }

    public void getMockRequest() {
        this.wiremockServer = new WireMockServer((Options)WireMockConfiguration.options().port(this.port));
        this.wiremockServer.start();
        this.wiremockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlPathMatching((String)"/response/.*")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{this.contentType}).withBody(this.response)));
    }

    public void stop() {
        this.wiremockServer.stop();
    }
}

