/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.stream.rest;

import com.tidal.stream.aws.Authorisation;
import com.tidal.stream.exceptions.RequestClassException;
import com.tidal.stream.exceptions.RuntimeTestException;
import com.tidal.stream.rest.DataEnum;
import com.tidal.stream.rest.ReqType;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class RestRequest {
    private static final ThreadLocal<RequestSpecification> requestSpec = new ThreadLocal();
    private static final ThreadLocal<ValidatableResponse> response = new ThreadLocal();
    private static final ThreadLocal<HashMap<String, Object>> map = new ThreadLocal();

    private RestRequest() {
    }

    public static RequestSpecification get() {
        if (requestSpec.get() == null) {
            throw new RequestClassException("RestRequest Specification has not been set up");
        }
        return requestSpec.get();
    }

    public static void set() {
        requestSpec.set(RestAssured.given().spec(new RequestSpecBuilder().build()));
        RestRequest.createMap();
    }

    public static void set(String baseUri) {
        requestSpec.set(RestAssured.given().spec(new RequestSpecBuilder().setBaseUri(baseUri).build()));
        RestRequest.createMap();
    }

    public static void setBaseUri(String baseUri) {
        RestAssured.baseURI = baseUri;
        requestSpec.set(RestAssured.given().spec(new RequestSpecBuilder().build()));
        RestRequest.createMap();
    }

    public static void resetSpec() {
        requestSpec.remove();
        requestSpec.set(RestAssured.given().spec(new RequestSpecBuilder().build()));
    }

    public static void reset() {
        requestSpec.remove();
        map.remove();
        response.remove();
        requestSpec.set(RestAssured.given().spec(new RequestSpecBuilder().build()));
    }

    public static void set(Authorisation authorisation) {
        Map headers = (Map)authorisation.getAuthHeaders();
        requestSpec.get().headers((Map)authorisation.getAuthHeaders());
    }

    public static <T> void setHeader(String key, T value) {
        requestSpec.get().header(key, value, new Object[0]);
    }

    public static <T> void setQueryParams(String key, T value) {
        requestSpec.get().queryParam(key, new Object[]{value});
    }

    public static <T> void setPayload(String payload) {
        requestSpec.get().body(payload);
    }

    public static <T> void setData(String key, T value) {
        map.get().put(key, value);
    }

    public static <T> void setData(DataEnum data, T value) {
        RestRequest.createMap();
        map.get().put(data.getValue(), value);
    }

    public static <T> T getData(String key) {
        return (T)map.get().get(key);
    }

    public static <T> Optional<T> getData(DataEnum data) {
        Object value;
        if (map.get() == null) {
            RestRequest.set();
        }
        if ((value = map.get().get(data.getValue())) == null) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static void send(ReqType reqType) {
        RestRequest.send(reqType, "");
    }

    public static void send(ReqType reqType, String uriOrPath) {
        switch (reqType) {
            case GET: {
                response.set((ValidatableResponse)((ValidatableResponse)((Response)requestSpec.get().when().get(uriOrPath, new Object[0])).then()).log().all());
                break;
            }
            case POST: {
                response.set((ValidatableResponse)((ValidatableResponse)((Response)requestSpec.get().when().post(uriOrPath, new Object[0])).then()).log().all());
                break;
            }
            case DELETE: {
                response.set((ValidatableResponse)((ValidatableResponse)((Response)requestSpec.get().when().delete(uriOrPath, new Object[0])).then()).log().all());
                break;
            }
            case PUT: {
                response.set((ValidatableResponse)((ValidatableResponse)((Response)requestSpec.get().when().put(uriOrPath, new Object[0])).then()).log().all());
                break;
            }
            case PATCH: {
                response.set((ValidatableResponse)((ValidatableResponse)((Response)requestSpec.get().when().patch(uriOrPath, new Object[0])).then()).log().all());
            }
        }
    }

    public static ValidatableResponse response() {
        if (response.get() == null) {
            throw new RuntimeTestException("Response is null : Check if the request is sent");
        }
        return response.get();
    }

    public static String getResponseString() {
        if (response.get() == null) {
            throw new RuntimeTestException("Response is null : Check if the request is sent");
        }
        return response.get().extract().asString();
    }

    public static void logResponse() {
        if (response.get() == null) {
            throw new RuntimeTestException("Response is null : Check if the request is sent");
        }
    }

    private static void createMap() {
        if (map.get() == null) {
            map.set(new HashMap());
        }
    }
}

