/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.browser;

import com.tidal.wave.browser.BrowserTypes;
import com.tidal.wave.browser.Driver;
import com.tidal.wave.data.DataCleaner;
import com.tidal.wave.data.GlobalData;
import com.tidal.wave.data.WaitTime;
import com.tidal.wave.data.WaitTimeData;
import com.tidal.wave.wait.Activity;
import java.time.Duration;
import java.util.HashMap;
import org.openqa.selenium.remote.AbstractDriverOptions;

public final class BrowserConfig {
    private String browserType;
    private AbstractDriverOptions<?> options;
    private Duration explicitWait;
    private final HashMap<Activity, Boolean> activityMap = new HashMap();
    private final Driver driver = new Driver();

    public BrowserConfig type(String browserType) {
        this.browserType = browserType;
        return this;
    }

    public BrowserConfig type(BrowserTypes browserType) {
        this.browserType = browserType.getBrowserName();
        return this;
    }

    public BrowserConfig withWaitTime(Duration explicitWait) {
        this.explicitWait = explicitWait;
        return this;
    }

    public BrowserConfig pageBackGroundActivity(Activity activity, boolean enable) {
        this.activityMap.put(activity, enable);
        return this;
    }

    public BrowserConfig withOptions(AbstractDriverOptions<?> options) {
        this.options = options;
        return this;
    }

    public void open(String url) {
        this.setOptionsAndCreateNewDriver(url);
    }

    public void close() {
        try {
            this.driver.close();
        }
        finally {
            DataCleaner.cleanData();
        }
    }

    private void setOptionsAndCreateNewDriver(String url) {
        this.setExplicitWaitTime();
        this.storePageBackGroundControlOptions();
        this.driver.create(this.browserType, this.options).navigateTo(url);
    }

    private void setExplicitWaitTime() {
        if (this.explicitWait != null) {
            WaitTimeData.setWaitTime(WaitTime.DEFAULT_WAIT_TIME, String.valueOf(this.explicitWait.getSeconds()));
        }
    }

    public void storePageBackGroundControlOptions() {
        if (!this.activityMap.isEmpty()) {
            this.activityMap.forEach((k, v) -> GlobalData.addData(k.getActivityType(), String.valueOf(v)));
        }
    }
}

