/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.browser;

import com.tidal.wave.browser.Chrome;
import com.tidal.wave.browser.Edge;
import com.tidal.wave.browser.Firefox;
import com.tidal.wave.utils.CheckString;
import java.util.Locale;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.AbstractDriverOptions;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariOptions;

public class BrowserFactory {
    public WebDriver getBrowser(String browser, AbstractDriverOptions<?> options) {
        if (CheckString.isNullOrEmpty(browser)) {
            return new Chrome().getDriver((ChromeOptions)options);
        }
        switch (browser.toUpperCase(Locale.ROOT)) {
            case "FIREFOX": {
                return new Firefox().getDriver((FirefoxOptions)options);
            }
            case "EDGE": {
                return new Edge().getDriver((EdgeOptions)options);
            }
            case "SAFARI": {
                return new SafariDriver((SafariOptions)options);
            }
        }
        return new Chrome().getDriver((ChromeOptions)options);
    }

    public WebDriver getBrowser() {
        return this.getBrowser(null, null);
    }
}

