/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.commands;

import com.tidal.wave.command.Command;
import com.tidal.wave.command.CommandAction;
import com.tidal.wave.command.CommandContext;
import com.tidal.wave.command.Commands;
import com.tidal.wave.counter.TimeCounter;
import com.tidal.wave.exceptions.CommandExceptions;
import com.tidal.wave.supplier.ObjectSupplier;
import com.tidal.wave.webelement.Element;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

public final class ClearAndType
extends CommandAction
implements Command {
    private final Supplier<Map<Class<? extends Throwable>, Supplier<String>>> ignoredExceptions = this::ignoredEx;
    private final Element webElement = (Element)ObjectSupplier.instanceOf(Element.class);
    private final TimeCounter timeCounter = new TimeCounter();
    private CharSequence[] charSequences;
    private boolean visibility;
    private boolean isMultiple;

    @Override
    public void contextSetter(CommandContext context) {
        this.charSequences = context.getSequence();
        this.locators = context.getLocators();
        this.visibility = context.getVisibility();
        this.isMultiple = context.isMultiple();
    }

    @Override
    public Map<Class<? extends Throwable>, Supplier<String>> ignoredEx() {
        return CommandExceptions.Of.clear();
    }

    public void clearAndTypeAction() {
        Function<WebElement, String> expectedValue = e -> e.getAttribute("value");
        WebElement element = this.webElement.getElement(this.locators, this.visibility, this.isMultiple);
        int existingCharsLength = expectedValue.apply(element).length();
        for (int i = 0; i < existingCharsLength; ++i) {
            element.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
        }
        for (CharSequence c : this.charSequences) {
            element.sendKeys(new CharSequence[]{c});
        }
    }

    public void clearAndType() {
        this.timeCounter.restart();
        super.execute(Commands.ClickCommands.CLEAR_AND_TYPE.toString(), this.ignoredExceptions, this.timeCounter);
    }
}

