/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.commands;

import com.tidal.wave.command.Command;
import com.tidal.wave.command.CommandAction;
import com.tidal.wave.command.CommandContext;
import com.tidal.wave.command.Commands;
import com.tidal.wave.counter.TimeCounter;
import com.tidal.wave.exceptions.CommandExceptions;
import com.tidal.wave.supplier.ObjectSupplier;
import com.tidal.wave.webelement.Element;
import java.util.Map;
import java.util.function.Supplier;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public final class SelectByText
extends CommandAction
implements Command {
    private final Supplier<Map<Class<? extends Throwable>, Supplier<String>>> ignoredExceptions = this::ignoredEx;
    private final Element webElement = (Element)ObjectSupplier.instanceOf(Element.class);
    private final TimeCounter timeCounter = new TimeCounter();
    private boolean isMultiple;
    private boolean visibility;
    private String selectionValue;

    @Override
    public void contextSetter(CommandContext context) {
        this.isMultiple = context.isMultiple();
        this.locators = context.getLocators();
        this.visibility = context.getVisibility();
        this.selectionValue = context.getTextInput();
    }

    @Override
    public Map<Class<? extends Throwable>, Supplier<String>> ignoredEx() {
        return CommandExceptions.TypeOf.stale();
    }

    public String selectByTextAction() {
        WebElement element = this.webElement.getElement(this.locators, this.visibility, this.isMultiple);
        Select select = new Select(element);
        select.selectByVisibleText(this.selectionValue);
        return select.getFirstSelectedOption().getText();
    }

    public String selectByText() {
        this.timeCounter.restart();
        return (String)super.execute(Commands.SelectCommands.SELECT_BY_TEXT.toString(), this.ignoredExceptions, this.timeCounter);
    }
}

