/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.propertieshandler;

import com.google.common.base.Strings;
import com.tidal.wave.encryptor.Decryptor;
import com.tidal.wave.exceptions.PropertyHandlerException;
import com.tidal.wave.propertieshandler.PropertiesHandler;
import java.util.Locale;
import java.util.Properties;

public class PropertiesFinder {
    private static final String SECRET_KEY_NAME = "secretKeyName";
    private static Properties propertiesController;
    private static String environment;
    private static Properties envProperties;
    private static Properties configProperties;

    private PropertiesFinder() {
    }

    public static String getEnvironment() {
        if (environment == null) {
            propertiesController = new PropertiesHandler("properties/controller.properties").getProperties();
            environment = PropertiesFinder.setEnvironment();
        }
        return environment;
    }

    public static String getProperty(String key) {
        if (!Strings.isNullOrEmpty((String)System.getenv(key))) {
            return System.getenv(key);
        }
        if (!Strings.isNullOrEmpty((String)System.getProperty(key))) {
            return System.getProperty(key);
        }
        configProperties = PropertiesFinder.getConfigProperties();
        String propertyValue = configProperties.getProperty(key);
        if (!Strings.isNullOrEmpty((String)propertyValue) && propertyValue.startsWith("ENC(")) {
            return Decryptor.decrypt(PropertiesFinder.getSecretKey(), propertyValue);
        }
        if (!Strings.isNullOrEmpty((String)propertyValue)) {
            return propertyValue;
        }
        envProperties = PropertiesFinder.getEnvProperties();
        String envProperty = envProperties.getProperty(key);
        if (!Strings.isNullOrEmpty((String)envProperty) && envProperty.startsWith("ENC(")) {
            return Decryptor.decrypt(PropertiesFinder.getSecretKey(), envProperty);
        }
        return envProperty;
    }

    private static String getSecretKey() {
        String secretKey;
        if (Strings.isNullOrEmpty((String)configProperties.getProperty(SECRET_KEY_NAME))) {
            throw new PropertyHandlerException("secretKeyName is null or cannot be found from 'configuration.properties' file.");
        }
        String secretKeyName = configProperties.getProperty(SECRET_KEY_NAME);
        String string = secretKey = System.getenv(secretKeyName) == null ? System.getProperty(secretKeyName) : System.getenv(secretKeyName);
        if (Strings.isNullOrEmpty((String)secretKey)) {
            throw new PropertyHandlerException(String.format("You do not have a secret value stored in your env variables with key '%s'", configProperties.getProperty(SECRET_KEY_NAME)));
        }
        return secretKey;
    }

    private static Properties getEnvProperties() {
        if (envProperties == null) {
            envProperties = new PropertiesHandler("properties/application-" + PropertiesFinder.getEnvironment().toLowerCase(Locale.ROOT) + ".properties").getProperties();
        }
        return envProperties;
    }

    private static Properties getConfigProperties() {
        if (configProperties == null) {
            configProperties = new PropertiesHandler("configuration.properties").getProperties();
        }
        return configProperties;
    }

    private static String setEnvironment() {
        String env = System.getenv("env");
        if (Strings.isNullOrEmpty((String)env)) {
            env = System.getProperty("env");
        }
        if (Strings.isNullOrEmpty((String)env)) {
            env = propertiesController.getProperty("environment");
        }
        return env;
    }
}

