/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.report;

import com.tidal.wave.report.ReportMatcher;
import com.tidal.wave.report.ReportModel;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Reporter {
    private static final String[] notFuncAssertion = new String[]{"TimeoutException", "Exception caused from action", "SQLServerException", "SnowflakeSQLLoggedException", "AlreadyClosedSqlException"};
    private static final String[] funcAssertion = new String[]{"TestAssertionError", "ComparisonFailure", "ExpectationFailure"};
    private static final String[] scriptIssues = new String[]{"NullPointerException"};
    private static final String[] notThrownException = new String[]{"SQLServerException", "SnowflakeSQLLoggedException", "AlreadyClosedSqlException"};

    private static String extractVerifications(String failureMessage) {
        StringBuilder failureMessageContent = new StringBuilder();
        String matchString = "Verification Failed:(.*?)Description:";
        Pattern pattern = Pattern.compile(matchString);
        Matcher matcher = pattern.matcher(failureMessage);
        while (matcher.find()) {
            String verificationMessage = matcher.group();
            verificationMessage = verificationMessage.replace("Verification Failed:", "").replace("Description:", "").trim();
            failureMessageContent.append(String.format("'%s';", verificationMessage));
        }
        return failureMessageContent.toString();
    }

    public static class OtherTypeFailures
    extends ReportMatcher {
        @Override
        public ReportModel parse(String typeContent, String errorMessage) {
            ReportModel reportModel = new ReportModel();
            reportModel.setGeneralFailure((String)(errorMessage.length() > 150 ? errorMessage.substring(0, 150) + " ...." : errorMessage));
            return reportModel;
        }
    }

    public static class ThrownException
    extends ReportMatcher {
        @Override
        public ReportModel parse(String typeContent, String errorMessage) {
            if (typeContent.contains("RuntimeTestException")) {
                if (Arrays.stream(notThrownException).noneMatch(errorMessage::contains)) {
                    ReportModel reportModel = new ReportModel();
                    reportModel.setFunctionalFailure(errorMessage);
                    return reportModel;
                }
            }
            return this.nextReportTypeMatcher.parse(typeContent, errorMessage);
        }
    }

    public static class ScriptFailure
    extends ReportMatcher {
        @Override
        public ReportModel parse(String typeContent, String errorMessage) {
            if (typeContent.contains("RuntimeTestException") && errorMessage.contains("TimeoutException")) {
                ReportModel reportModel = new ReportModel();
                reportModel.setScriptFailure(errorMessage.substring(errorMessage.indexOf("TimeoutException:") + "TimeoutException:".length(), errorMessage.indexOf("Build info:")).trim());
                return reportModel;
            }
            if (typeContent.contains("RuntimeTestException") && errorMessage.contains("Details:")) {
                String errorMessageSubString = errorMessage.substring(errorMessage.indexOf("RuntimeTestException:") + "RuntimeTestException:".length(), errorMessage.indexOf("Details:"));
                if (typeContent.contains("Exception caused from action")) {
                    ReportModel reportModel = new ReportModel();
                    reportModel.setScriptFailure(errorMessageSubString.trim());
                    return reportModel;
                }
                if (errorMessage.contains("Exception caused from action")) {
                    ReportModel reportModel = new ReportModel();
                    String errorDetails = errorMessage.substring(errorMessage.indexOf("Details:") + "Details:".length()).trim();
                    if (errorDetails.startsWith("null")) {
                        errorDetails = errorMessageSubString;
                    }
                    reportModel.setScriptFailure(errorDetails);
                    return reportModel;
                }
            }
            return this.nextReportTypeMatcher.parse(typeContent, errorMessage);
        }
    }

    public static class FunctionalFailure
    extends ReportMatcher {
        @Override
        public ReportModel parse(String typeContent, String errorMessage) {
            if (typeContent.contains("VerificationError")) {
                ReportModel reportModel = new ReportModel();
                reportModel.setFunctionalFailure(Reporter.extractVerifications(errorMessage));
                return reportModel;
            }
            if (Arrays.stream(funcAssertion).anyMatch(typeContent::contains)) {
                ReportModel reportModel = new ReportModel();
                reportModel.setFunctionalFailure(errorMessage.replace("\n", "'"));
                return reportModel;
            }
            if (typeContent.contains("RuntimeTestException")) {
                if (Arrays.stream(notFuncAssertion).noneMatch(errorMessage::contains)) {
                    ReportModel reportModel = new ReportModel();
                    reportModel.setFunctionalFailure(errorMessage);
                    return reportModel;
                }
            }
            return this.nextReportTypeMatcher.parse(typeContent, errorMessage);
        }
    }
}

