/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.verification.conditions.collections;

import com.tidal.wave.command.Executor;
import com.tidal.wave.commands.GetSize;
import com.tidal.wave.supplier.ObjectSupplier;
import com.tidal.wave.verification.conditions.collections.CollectionsCondition;
import com.tidal.wave.wait.FluentWait;
import java.time.Duration;
import java.util.List;
import org.openqa.selenium.By;

public class CollectionSizeLessThan
extends CollectionsCondition {
    private final int value;
    private final Executor executor = (Executor)ObjectSupplier.instanceOf(Executor.class);

    public CollectionSizeLessThan(int value) {
        this.value = value;
    }

    @Override
    public void verify(boolean isVisible, boolean isMultiple, List<By> locators) {
        Duration waitDuration = Duration.ofSeconds(1L);
        new FluentWait<Executor>(this.executor).pollingEvery(Duration.ofMillis(500L)).forDuration(waitDuration).withMessage(String.format("Expected number of elements is less than %d but found %d element[s]", this.value, (int)((Integer)this.executor.isVisible(isVisible).withMultipleElements(isMultiple).usingLocator(locators).invokeCommand(GetSize.class, "getSize")))).until(e -> (Integer)e.isVisible(isVisible).withMultipleElements(isMultiple).usingLocator(locators).invokeCommand(GetSize.class, "getSize") < this.value);
    }
}

