/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.webelement;

import com.tidal.wave.command.Executor;
import com.tidal.wave.commands.Check;
import com.tidal.wave.commands.Clear;
import com.tidal.wave.commands.ClearAndType;
import com.tidal.wave.commands.Click;
import com.tidal.wave.commands.ClickByAction;
import com.tidal.wave.commands.ClickByJS;
import com.tidal.wave.commands.DoubleClick;
import com.tidal.wave.commands.DragAndDrop;
import com.tidal.wave.commands.FileUpload;
import com.tidal.wave.commands.FileUploadWRC;
import com.tidal.wave.commands.FindTextData;
import com.tidal.wave.commands.ForceClick;
import com.tidal.wave.commands.GetAllAttributes;
import com.tidal.wave.commands.GetAllCssAttributes;
import com.tidal.wave.commands.GetAttribute;
import com.tidal.wave.commands.GetCssAttribute;
import com.tidal.wave.commands.GetDimension;
import com.tidal.wave.commands.GetLocation;
import com.tidal.wave.commands.GetRect;
import com.tidal.wave.commands.GetTagName;
import com.tidal.wave.commands.Hover;
import com.tidal.wave.commands.IsEnabled;
import com.tidal.wave.commands.IsSelected;
import com.tidal.wave.commands.IsVisible;
import com.tidal.wave.commands.MoveByOffSet;
import com.tidal.wave.commands.MoveToElement;
import com.tidal.wave.commands.PressEnter;
import com.tidal.wave.commands.PressTab;
import com.tidal.wave.commands.RightClick;
import com.tidal.wave.commands.ScrollPage;
import com.tidal.wave.commands.ScrollToView;
import com.tidal.wave.commands.SelectByIndex;
import com.tidal.wave.commands.SelectByText;
import com.tidal.wave.commands.SelectByValue;
import com.tidal.wave.commands.SendKeys;
import com.tidal.wave.commands.SetInnerHtml;
import com.tidal.wave.commands.SetText;
import com.tidal.wave.commands.SetValue;
import com.tidal.wave.commands.UnCheck;
import com.tidal.wave.data.DataEnum;
import com.tidal.wave.data.GlobalData;
import com.tidal.wave.locator.LocatorMatcher;
import com.tidal.wave.retry.Retry;
import com.tidal.wave.retry.RetryCondition;
import com.tidal.wave.supplier.ObjectSupplier;
import com.tidal.wave.verification.conditions.Condition;
import com.tidal.wave.verification.conditions.TestVerification;
import com.tidal.wave.verification.criteria.Criteria;
import com.tidal.wave.verification.criteria.EnsureElementState;
import com.tidal.wave.verification.expectations.Expectation;
import com.tidal.wave.verification.expectations.SoftAssertion;
import com.tidal.wave.wait.ThreadSleep;
import com.tidal.wave.wait.Wait;
import com.tidal.wave.webelement.UIElement;
import com.tidal.wave.webelement.UIElements;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;

public class UIActions
implements UIElement {
    private final Executor executor = (Executor)ObjectSupplier.instanceOf(Executor.class);
    private List<By> locators;
    private boolean visibility = true;
    private boolean isMultiple = false;

    protected UIActions setProperties(By byLocator) {
        this.isMultiple = false;
        this.visibility = true;
        this.locators = new LinkedList<By>();
        this.locators.add(byLocator);
        this.executor.isVisible(true).withMultipleElements(false).clearCommands();
        return this;
    }

    public void setMultiple() {
        this.isMultiple = true;
        this.executor.withMultipleElements(true);
    }

    protected UIActions withDefaultWait() {
        Wait.setDefaultWait();
        return this;
    }

    @Override
    public UIActions invisibleElement() {
        this.visibility = false;
        this.executor.isVisible(false);
        return this;
    }

    @Override
    public UIActions click() {
        this.executor.usingLocator(this.locators).invokeCommand(Click.class);
        return this;
    }

    @Override
    public UIActions sendKeys(CharSequence ... keysToSend) {
        Objects.requireNonNull(keysToSend, "The input value for 'SendKeys' should not be null");
        this.executor.usingLocator(this.locators).withCharSequence(keysToSend).invokeCommand(SendKeys.class);
        return this;
    }

    @Override
    public UIActions setText(String text) {
        Objects.requireNonNull(text, "The input value for 'SetText' should not be null");
        this.executor.usingLocator(this.locators).withText(text).invokeCommand(SetText.class);
        return this;
    }

    @Override
    public UIActions setValue(String value) {
        this.executor.usingLocator(this.locators).withText(value).invokeCommand(SetValue.class);
        return this;
    }

    @Override
    public UIActions setInnerHtml(String value) {
        this.executor.usingLocator(this.locators).withText(value).invokeCommand(SetInnerHtml.class);
        return this;
    }

    @Override
    public UIActions clearAndType(CharSequence ... charSequences) {
        this.executor.usingLocator(this.locators).withCharSequence(charSequences).invokeCommand(ClearAndType.class);
        return this;
    }

    @Override
    public UIActions clear() {
        this.executor.usingLocator(this.locators).invokeCommand(Clear.class);
        return this;
    }

    @Override
    public String getAttribute(String value) {
        return (String)this.executor.usingLocator(this.locators).withAttribute(value).invokeCommand(GetAttribute.class);
    }

    @Override
    public String getCSSAttribute(String value) {
        return (String)this.executor.usingLocator(this.locators).withAttribute(value).invokeCommand(GetCssAttribute.class);
    }

    @Override
    public String getAllCSSAttributes() {
        return (String)this.executor.usingLocator(this.locators).invokeCommand(GetAllCssAttributes.class);
    }

    @Override
    public Map<String, String> getAllAttributes() {
        return (Map)this.executor.usingLocator(this.locators).invokeCommand(GetAllAttributes.class);
    }

    @Override
    public String getTagName() {
        return (String)this.executor.usingLocator(this.locators).invokeCommand(GetTagName.class);
    }

    @Override
    public Point getLocation() {
        return (Point)this.executor.usingLocator(this.locators).invokeCommand(GetLocation.class);
    }

    @Override
    public Rectangle getRect() {
        return (Rectangle)this.executor.usingLocator(this.locators).invokeCommand(GetRect.class);
    }

    @Override
    public Dimension getDimension() {
        return (Dimension)this.executor.usingLocator(this.locators).invokeCommand(GetDimension.class);
    }

    @Override
    public boolean isDisplayed() {
        return (Boolean)this.executor.usingLocator(this.locators).invokeCommand(IsVisible.class);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.executor.usingLocator(this.locators).invokeCommand(IsEnabled.class);
    }

    @Override
    public boolean isSelected() {
        return (Boolean)this.executor.usingLocator(this.locators).invokeCommand(IsSelected.class);
    }

    @Override
    public String getText() {
        return (String)this.executor.usingLocator(this.locators).invokeCommand(FindTextData.class);
    }

    @Override
    public UIActions check() {
        this.executor.usingLocator(this.locators).invokeCommand(Check.class);
        return this;
    }

    @Override
    public UIActions inShadowDom(String locator) {
        return null;
    }

    @Override
    public UIActions inShadowDom() {
        this.addData("SE", "true");
        this.executor.presenceOfShadownDom();
        return this;
    }

    @Override
    public UIActions unCheck() {
        this.executor.usingLocator(this.locators).invokeCommand(UnCheck.class);
        return this;
    }

    @Override
    public String select(String selectValue) {
        return (String)this.executor.usingLocator(this.locators).withText(selectValue).invokeCommand(SelectByText.class);
    }

    @Override
    public String selectByValue(String selectValue) {
        return (String)this.executor.usingLocator(this.locators).withText(selectValue).invokeCommand(SelectByValue.class);
    }

    @Override
    public String select(int index) {
        return (String)this.executor.usingLocator(this.locators).withSelectIndex(index).invokeCommand(SelectByIndex.class);
    }

    @Override
    public UIActions moveToElement() {
        this.executor.usingLocator(this.locators).invokeCommand(MoveToElement.class);
        return this;
    }

    @Override
    public void doubleClick() {
        this.executor.usingLocator(this.locators).invokeCommand(DoubleClick.class);
    }

    @Override
    public void rightClick() {
        this.executor.usingLocator(this.locators).invokeCommand(RightClick.class);
    }

    @Override
    public void contextClick() {
        this.executor.usingLocator(this.locators).invokeCommand(RightClick.class);
    }

    @Override
    public void actionClick() {
        this.executor.usingLocator(this.locators).invokeCommand(ClickByAction.class);
    }

    @Override
    public void forceClick() {
        this.executor.usingLocator(this.locators).invokeCommand(ForceClick.class);
    }

    @Override
    public UIActions pressTab() {
        this.executor.usingLocator(this.locators).invokeCommand(PressTab.class);
        return this;
    }

    @Override
    public UIActions pressTab(int times) {
        this.executor.usingLocator(this.locators).withTabIndex(times).invokeCommand(PressTab.class);
        return this;
    }

    @Override
    public void pressEnter() {
        this.executor.usingLocator(this.locators).invokeCommand(PressEnter.class);
    }

    @Override
    public void clickByJS() {
        this.executor.usingLocator(this.locators).invokeCommand(ClickByJS.class);
    }

    @Override
    public UIActions hover(int secondsToHover) {
        this.executor.usingLocator(this.locators).withTimeToWait(secondsToHover).invokeCommand(Hover.class);
        return this;
    }

    @Override
    public UIActions scrollToView() {
        this.executor.usingLocator(this.locators).invokeCommand(ScrollToView.class);
        return this;
    }

    @Override
    public UIActions scrollPage(int xDirection, int yDirection) {
        this.executor.usingLocator(this.locators).withXYCords(xDirection, yDirection).invokeCommand(ScrollPage.class);
        return this;
    }

    @Override
    public UIActions moveByOffset(int xDirection, int yDirection) {
        this.executor.usingLocator(this.locators).withXYCords(xDirection, yDirection).invokeCommand(MoveByOffSet.class);
        return this;
    }

    @Override
    public void dragAndDrop() {
        this.executor.usingLocator(this.locators).invokeCommand(DragAndDrop.class);
    }

    @Override
    public void dragAndDropByOffset(int xDirection, int yDirection) {
        this.executor.usingLocator(this.locators).withXYCords(xDirection, yDirection).invokeCommand(DragAndDrop.class);
    }

    @Override
    public UIActions thenFind(String locatorMatcher) {
        this.locators.add(LocatorMatcher.getMatchedLocator(locatorMatcher));
        return this;
    }

    private UIElements thenFindAll(By byNewLocator) {
        this.locators.add(byNewLocator);
        UIElements uiElements = new UIElements();
        uiElements.setElementProperties(this, this.visibility);
        return uiElements;
    }

    @Override
    public UIElements thenFindAll(String byNewLocatorMatcher) {
        return this.thenFindAll(LocatorMatcher.getMatchedLocator(byNewLocatorMatcher));
    }

    @Override
    public UIActions waitFor(int waitTime) {
        Wait.setExplicitWait(waitTime);
        return this;
    }

    @Override
    public void retryIf(Supplier<RetryCondition> retryCondition) {
        Retry.retry(this.visibility, this.isMultiple, this.locators, retryCondition.get(), 1);
    }

    @Override
    public void retryIf(RetryCondition retryCondition) {
        Retry.retry(this.visibility, this.isMultiple, this.locators, retryCondition, 1);
    }

    @Override
    public void retryIf(Supplier<RetryCondition> retryCondition, int numberOfTimes) {
        Retry.retry(this.visibility, this.isMultiple, this.locators, retryCondition.get(), numberOfTimes);
    }

    @Override
    public void retryIf(RetryCondition retryCondition, int numberOfTimes) {
        Retry.retry(this.visibility, this.isMultiple, this.locators, retryCondition, numberOfTimes);
    }

    @Override
    public Expectation expecting(Expectation expectation) {
        return SoftAssertion.softAssert(this.visibility, this.isMultiple, this.locators, expectation);
    }

    @Override
    public Expectation expecting(Supplier<Expectation> expectation) {
        return SoftAssertion.softAssert(this.visibility, this.isMultiple, this.locators, expectation.get());
    }

    @Override
    public void shouldHave(Condition ... condition) {
        TestVerification.verification(this.visibility, this.isMultiple, this.locators, condition);
    }

    @Override
    public final UIActions shouldBe(Criteria ... criteria) {
        EnsureElementState.affirmation(this.visibility, this.isMultiple, this.locators, criteria);
        return this;
    }

    @Override
    public final UIActions shouldBe(Supplier<Criteria> criteria) {
        Supplier[] criterion = new Supplier[]{criteria};
        EnsureElementState.affirmation(this.visibility, this.isMultiple, this.locators, criterion);
        return this;
    }

    @Override
    public final UIActions shouldBe(Supplier<Criteria> criteria1, Supplier<Criteria> criteria2) {
        Supplier[] criterion = new Supplier[]{criteria1, criteria2};
        EnsureElementState.affirmation(this.visibility, this.isMultiple, this.locators, criterion);
        return this;
    }

    @Override
    public UIActions addData(String key) {
        GlobalData.addData(key, (String)this.executor.usingLocator(this.locators).invokeCommand(FindTextData.class, "findTextData"));
        return this;
    }

    @Override
    public UIActions addData(DataEnum key) {
        GlobalData.addData(key, (String)this.executor.usingLocator(this.locators).invokeCommand(FindTextData.class, "findTextData"));
        return this;
    }

    @Override
    public void addData(String key, String value) {
        GlobalData.addData(key, value);
    }

    @Override
    public void uploadFile(@NotNull String fileName) {
        this.executor.usingLocator(this.locators).withText(fileName).invokeCommand(FileUpload.class);
    }

    @Override
    public void uploadFileWRC(@NotNull String fileName) {
        this.executor.usingLocator(this.locators).withText(fileName).invokeCommand(FileUploadWRC.class);
    }

    @Override
    public UIActions pause(int seconds) {
        ThreadSleep.forSeconds(seconds);
        return this;
    }

    protected List<By> getLocators() {
        return this.locators;
    }
}

