/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.commands;

import com.tidal.wave.command.Command;
import com.tidal.wave.command.CommandAction;
import com.tidal.wave.command.CommandContext;
import com.tidal.wave.command.Commands;
import com.tidal.wave.counter.TimeCounter;
import com.tidal.wave.exceptions.CommandExceptions;
import com.tidal.wave.exceptions.RuntimeTestException;
import com.tidal.wave.supplier.ObjectSupplier;
import com.tidal.wave.webelement.Element;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Supplier;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.RemoteWebElement;

public final class DragAndDrop
extends CommandAction
implements Command {
    private final Supplier<Map<Class<? extends Throwable>, Supplier<String>>> ignoredExceptions = this::ignoredEx;
    private final Element webElement = (Element)ObjectSupplier.instanceOf(Element.class);
    private final TimeCounter timeCounter = new TimeCounter();
    private boolean isMultiple;

    @Override
    public void contextSetter(CommandContext context) {
        this.locators = context.getLocators();
        this.isMultiple = context.isMultiple();
    }

    @Override
    public Map<Class<? extends Throwable>, Supplier<String>> ignoredEx() {
        return CommandExceptions.TypeOf.stale();
    }

    public void dragAndDropAction() {
        if (this.locators.size() <= 1) {
            throw new RuntimeTestException("Expecting two locators but found only one. \nFor drag and drop two web elements needed to be found. \nUse the format find(byLocator(x)).thenFind(byLocator(y)).dragAndDrop(); ");
        }
        LinkedList<By> linkedListOne = new LinkedList<By>();
        linkedListOne.add((By)this.locators.get(0));
        WebElement sourceElement = this.webElement.getElement(linkedListOne, false, this.isMultiple);
        LinkedList<By> linkedListTwo = new LinkedList<By>();
        linkedListTwo.add((By)this.locators.get(1));
        WebElement targetElement = this.webElement.getElement(linkedListTwo, false, this.isMultiple);
        new Actions(((RemoteWebElement)sourceElement).getWrappedDriver()).dragAndDrop(sourceElement, targetElement).perform();
    }

    public void dragAndDrop() {
        this.timeCounter.restart();
        super.execute(Commands.MoveCommands.DRAG_AND_DROP.toString(), this.ignoredExceptions, this.timeCounter);
    }
}

