/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.commands;

import com.tidal.wave.command.Command;
import com.tidal.wave.command.CommandAction;
import com.tidal.wave.command.CommandContext;
import com.tidal.wave.command.Commands;
import com.tidal.wave.counter.TimeCounter;
import com.tidal.wave.exceptions.CommandExceptions;
import com.tidal.wave.exceptions.NoSuchFileException;
import com.tidal.wave.filehandlers.Finder;
import com.tidal.wave.supplier.ObjectSupplier;
import com.tidal.wave.webelement.Element;
import java.awt.AWTException;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.Map;
import java.util.function.Supplier;
import org.openqa.selenium.WebElement;

public class FileUploadWRC
extends CommandAction
implements Command {
    private final Supplier<Map<Class<? extends Throwable>, Supplier<String>>> ignoredExceptions = this::ignoredEx;
    private final Element webElement = (Element)ObjectSupplier.instanceOf(Element.class);
    private final TimeCounter timeCounter = new TimeCounter();
    private boolean isMultiple;
    private boolean visibility;
    private String fileName;
    private String filePath;

    @Override
    public void contextSetter(CommandContext context) {
        this.isMultiple = context.isMultiple();
        this.locators = context.getLocators();
        this.visibility = context.getVisibility();
        this.fileName = context.getTextInput();
    }

    @Override
    protected Map<Class<? extends Throwable>, Supplier<String>> ignoredEx() {
        return CommandExceptions.TypeOf.stale();
    }

    public void fileUploadAction() throws AWTException {
        WebElement element = this.webElement.getElement(this.locators, this.visibility, this.isMultiple);
        element.click();
        Robot robot = new Robot();
        StringSelection stringSelection = new StringSelection(this.filePath);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
        robot.keyPress(17);
        robot.keyPress(86);
        robot.keyRelease(17);
        robot.keyRelease(86);
        robot.keyPress(10);
        robot.keyRelease(10);
    }

    public void fileUploadWRC() {
        if (this.fileName.isEmpty()) {
            throw new IllegalArgumentException("File name should not be null or empty");
        }
        if (!Finder.findFileIfExists(this.fileName).isPresent()) {
            throw new NoSuchFileException(String.format("No file could be found with the given file name '%s'", this.fileName));
        }
        this.filePath = Finder.findFilePath(this.fileName);
        this.timeCounter.restart();
        super.execute(Commands.InputCommands.UPLOAD_FILE.toString(), this.ignoredExceptions, this.timeCounter);
    }
}

