/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.page;

import com.tidal.wave.browser.Driver;
import com.tidal.wave.loggers.Logger;
import com.tidal.wave.wait.Wait;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class Page {
    private static final Logger logger = new Logger().forClass(Page.class);

    private Page() {
    }

    public static void navigateTo(String url) {
        Driver.getDriver().navigate().to(url);
    }

    public static void refresh() {
        Driver.getDriver().navigate().refresh();
    }

    public static String title() {
        return Driver.getDriver().getTitle();
    }

    public static String currentUrl() {
        return Driver.getDriver().getCurrentUrl();
    }

    public static Set<String> getWindowHandles() {
        return Driver.getDriver().getWindowHandles();
    }

    public static String getWindowHandle() {
        return Driver.getDriver().getWindowHandle();
    }

    public static String getPageSource() {
        return Driver.getDriver().getPageSource();
    }

    public static Alert switchToAlert() {
        WebDriverWait wait = Wait.getWait();
        wait.until((Function)ExpectedConditions.alertIsPresent());
        return Driver.getDriver().switchTo().alert();
    }

    public static void dismissAlert() {
        Page.switchToAlert().dismiss();
    }

    public static void acceptAlert() {
        Page.switchToAlert().accept();
    }

    public static Alert sendTextToAlert(String text) {
        Alert alert = Page.switchToAlert();
        alert.sendKeys(text);
        return alert;
    }

    public static String getAlertText() {
        return Page.switchToAlert().getText();
    }

    public static List<String> getConsoleLog() {
        LogEntries logEntries = Driver.getDriver().manage().logs().get("browser");
        ArrayList<String> consoleLog = new ArrayList<String>();
        for (LogEntry entry : logEntries) {
            logger.info(entry.getLevel() + " " + entry.getMessage());
            consoleLog.add(entry.getMessage());
        }
        return consoleLog;
    }

    public static LogEntries getConsoleLogEntries() {
        return Driver.getDriver().manage().logs().get("browser");
    }

    public static String getCapability(String capability) {
        Capabilities caps = ((RemoteWebDriver)Driver.getDriver()).getCapabilities();
        if (caps.asMap().get(capability) != null) {
            return caps.asMap().get(capability).toString();
        }
        return String.format("No such capability existing/set for the given %s browser", StringUtils.capitalize((String)caps.asMap().get("browserName").toString()));
    }

    public static Map<String, Object> getCapabilities() {
        return ((RemoteWebDriver)Driver.getDriver()).getCapabilities().asMap();
    }
}

