/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.tabsandwindows;

import com.tidal.wave.browser.Driver;
import com.tidal.wave.tabsandwindows.BrowserWindows;
import com.tidal.wave.tabsandwindows.FirstTab;
import com.tidal.wave.tabsandwindows.LastTab;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WindowType;

public class Tabs {
    public static final Supplier<BrowserWindows> first = Tabs::firstTab;
    public static final Supplier<BrowserWindows> last = Tabs::lastTab;
    private static final ThreadLocal<ArrayList<String>> windowHandles = new ThreadLocal();
    private static String currentHandle;

    public static void openNewTab(String url) {
        WebDriver driver = Driver.getDriver();
        driver.switchTo().newWindow(WindowType.TAB);
        Tabs.switchToTab(last);
        driver.navigate().to(url);
    }

    private Tabs() {
    }

    public static void switchToTab(int index) {
        if (index == 0) {
            ++index;
        }
        Tabs.captureWindowHandles();
        currentHandle = windowHandles.get().get(index - 1);
        Driver.getDriver().switchTo().window(currentHandle);
    }

    public static void switchToTab(Supplier<BrowserWindows> tabOrder) {
        Tabs.captureWindowHandles();
        currentHandle = windowHandles.get().get(tabOrder.get().getIndex(windowHandles.get().size()) - 1);
        Driver.getDriver().switchTo().window(currentHandle);
    }

    public static void closeTab() {
        Driver.getDriver().close();
        Tabs.switchToTab(last);
    }

    public static void closeTab(Supplier<BrowserWindows> tabOrder) {
        Tabs.switchToTab(tabOrder);
        Driver.getDriver().close();
        Tabs.switchToTab(tabOrder);
    }

    public static void closeTab(int index) {
        Tabs.switchToTab(index);
        Driver.getDriver().close();
    }

    public static void remove() {
        windowHandles.remove();
    }

    private static void captureWindowHandles() {
        windowHandles.set(new ArrayList(Driver.getDriver().getWindowHandles()));
    }

    private static BrowserWindows firstTab() {
        return new FirstTab();
    }

    private static BrowserWindows lastTab() {
        return new LastTab();
    }
}

