/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.webelement;

import com.tidal.wave.browser.Driver;
import com.tidal.wave.exceptions.IterationStopper;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class IframeIterator {
    protected WebElement contextElement;

    public boolean switchToIframeOfElement(By locator, boolean visibility) throws IterationStopper {
        WebDriver driver = Driver.getDriver();
        List elements = driver.findElements(locator);
        if (!elements.isEmpty()) {
            return this.checkVisibleCondition(elements, visibility);
        }
        driver.switchTo().defaultContent();
        return this.findElementsIframe(locator, visibility);
    }

    private boolean findElementsIframe(By locator, boolean visibility) throws IterationStopper {
        WebDriver driver = Driver.getDriver();
        List iframes = driver.findElements(By.xpath((String)"//iframe"));
        for (WebElement iframe : iframes) {
            driver.switchTo().frame(iframe);
            List elements = driver.findElements(locator);
            if (!elements.isEmpty() && this.checkVisibleCondition(elements, visibility)) {
                throw new IterationStopper("This exception is thrown to stop iteration after the element is found. Unless an exception is thrown, the iteration will continue the full cycle. So if this exception is thrown, it means the element is found");
            }
            this.findElementsIframe(locator, visibility);
        }
        driver.switchTo().parentFrame();
        return false;
    }

    private boolean checkVisibleCondition(List<WebElement> elements, boolean visibility) {
        if (visibility) {
            return this.findDisplayedElement(elements);
        }
        if (!elements.isEmpty()) {
            this.contextElement = elements.get(0);
            return true;
        }
        return false;
    }

    private boolean findDisplayedElement(List<WebElement> elements) {
        for (WebElement element : elements) {
            if (!element.isDisplayed()) continue;
            this.contextElement = element;
            return true;
        }
        return false;
    }
}

