/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.command;

import com.tidal.wave.command.Command;
import com.tidal.wave.command.CommandContext;
import com.tidal.wave.command.ExecutorCommands;
import com.tidal.wave.supplier.ObjectSupplier;
import java.beans.Introspector;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openqa.selenium.By;

public class Executor
implements ExecutorCommands {
    private static final Logger logger = LogManager.getLogger(Executor.class);
    Map<String, Command> commandCollection = new ConcurrentHashMap<String, Command>(200);
    CommandContext context = (CommandContext)ObjectSupplier.instanceOf(CommandContext.class);
    List<Class<? extends Command>> commands = new LinkedList<Class<? extends Command>>();

    Command getInstance(Class<? extends Command> inputClass) {
        String className = inputClass.getSimpleName();
        try {
            if (this.commandCollection.get(className) == null) {
                logger.debug(String.format("No instance found for class %s, creating a new one", className));
                Command classInstance = inputClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.commandCollection.put(className, classInstance);
            }
        }
        catch (Exception e) {
            logger.error(String.format("Exception thrown with class initiation for %s", className));
            logger.error(e.getMessage());
        }
        return this.commandCollection.get(className);
    }

    @Override
    public <T> T invokeCommand(Class<? extends Command> commandClass, String method) {
        this.getInstance(commandClass).contextSetter(this.context);
        return this.getInstance(commandClass).execute(method);
    }

    @Override
    public <T> T invokeCommand(Class<? extends Command> commandClass) {
        this.getInstance(commandClass).contextSetter(this.context);
        this.commands.add(commandClass);
        return this.getInstance(commandClass).execute(Introspector.decapitalize(commandClass.getSimpleName()));
    }

    @Override
    public void invokeCommand() {
        this.commands.forEach(c -> this.getInstance((Class<? extends Command>)c).execute(Introspector.decapitalize(c.getSimpleName())));
    }

    @Override
    public void clearCommands() {
        this.commands.clear();
    }

    @Override
    public Executor withMultipleElements(boolean isTrue) {
        this.context.setMultiple(isTrue);
        return this;
    }

    @Override
    public Executor withText(String text) {
        this.context.setTextInput(text);
        return this;
    }

    @Override
    public Executor withTabIndex(int index) {
        this.context.setTabIndex(index);
        return this;
    }

    @Override
    public Executor withTimeToWait(int seconds) {
        this.context.setSecondsToWait(seconds);
        return this;
    }

    @Override
    public Executor withAttribute(String attributeName) {
        this.context.setAttributeName(attributeName);
        return this;
    }

    @Override
    public Executor withCharSequence(CharSequence ... sequence) {
        this.context.setSequence(sequence);
        return this;
    }

    @Override
    public Executor withSelectIndex(int index) {
        this.context.setSelectIndex(index);
        return this;
    }

    @Override
    public Executor isVisible(boolean visible) {
        this.context.setVisibility(visible);
        return this;
    }

    @Override
    public Executor presenceOfShadownDom() {
        this.context.setShadowDomPresence();
        return this;
    }

    @Override
    public Executor usingLocator(List<By> locators) {
        this.context.setLocatorSet(locators);
        return this;
    }

    @Override
    public Executor withXYCords(int xCords, int yCords) {
        this.context.setXYCords(xCords, yCords);
        return this;
    }

    @Override
    public Executor withZoomLevel(double zoomLevel) {
        this.context.setZoomLevel(zoomLevel);
        return this;
    }
}

