/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.report;

import com.google.common.base.Functions;
import com.tidal.wave.filehandlers.FileOutWriter;
import com.tidal.wave.filehandlers.FilePaths;
import com.tidal.wave.filehandlers.FileReader;
import com.tidal.wave.propertieshandler.Config;
import com.tidal.wave.propertieshandler.PropertiesFinder;
import com.tidal.wave.report.ReportMatcher;
import com.tidal.wave.report.ReportModel;
import com.tidal.wave.report.Reporter;
import com.tidal.wave.utils.Helper;
import com.tidal.wave.xml.XMLReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReportBuilder {
    private static final Logger logger = Logger.getLogger("ReportBuilder");
    private static final String FINAL_RESULT_FILE = "TestResultFinal.xml";
    private static final String RESULT_FOLDER_NAME = "test-summary";
    private static final Path TARGET_FOLDER_PATH = Paths.get(Helper.getAbsoluteFromRelativePath(FilePaths.TARGET_FOLDER_PATH.getPath()), new String[0]);
    private static final Path PATH_TO_WRITE_FILE = Paths.get(TARGET_FOLDER_PATH.toString(), "test-summary", "TestResult.csv");
    private static final List<String> testFailures = new ArrayList<String>();
    private static final String REPORT_HEADERS = "Test Case, Result, Functional Failure, Script Failure, Other, Duration(Seconds)";
    private static final ReportMatcher functionalMatcher = new Reporter.FunctionalFailure();
    private static final ReportMatcher scriptFailure = new Reporter.ScriptFailure();
    private static final ReportMatcher thrownExceptionFailure = new Reporter.ThrownException();
    private static final ReportMatcher genericFailure = new Reporter.OtherTypeFailures();
    private static final ReportMatcher reportMatcher;

    private ReportBuilder() {
    }

    public static void createRunnerReport() {
        if (Config.RETRY_FAILED_TESTS) {
            return;
        }
        ReportBuilder.createReport();
    }

    public static void createReport() {
        StringBuilder result = new StringBuilder(REPORT_HEADERS);
        result.append(System.lineSeparator());
        String testResultFinalXML = FileReader.readFileToString(FINAL_RESULT_FILE, TARGET_FOLDER_PATH);
        List<Node> runnerResult = ReportBuilder.getTestCasesFrom(testResultFinalXML);
        for (Node node : runnerResult) {
            result.append(ReportBuilder.analyseResult(node));
        }
        result.append(ReportBuilder.addAdditionalPipelineInfo(testResultFinalXML, runnerResult));
        FileOutWriter.createTargetFolderDirectory(RESULT_FOLDER_NAME);
        FileOutWriter.writeFileTo(result.toString(), PATH_TO_WRITE_FILE.toString());
    }

    private static String addAdditionalPipelineInfo(String testResultFinalXML, List<Node> runnerResult) {
        StringBuilder result = new StringBuilder();
        IntStream.range(0, 3).forEach(e -> result.append(System.lineSeparator()));
        String pipelineName = PropertiesFinder.getProperty("build.definitionName");
        String projectName = PropertiesFinder.getProperty("build.repository.name");
        String branchName = PropertiesFinder.getProperty("build.sourceBranchName");
        int totalPassedTests = ReportBuilder.getTotalPassedTests(runnerResult);
        int totalFailedTests = Integer.parseInt(ReportBuilder.getTotalFailedTests(testResultFinalXML));
        float passPercentage = (float)Math.floor((float)(totalPassedTests * 100) / (float)(totalFailedTests + totalPassedTests) * 100.0f) / 100.0f;
        float totalRunTime = ReportBuilder.getTotalRunTime(testResultFinalXML);
        int timeInHours = (int)(totalRunTime / 3600.0f);
        int timeInMinutes = (int)(totalRunTime % 3600.0f / 60.0f);
        int totalSeconds = (int)(totalRunTime % 60.0f);
        Object totalTime = String.format("%02d:%02d:%02d", timeInHours, timeInMinutes, totalSeconds);
        totalTime = (String)totalTime + " (This is the total run time if tests run sequentially. It does not take into account the time saved by parallel runs)";
        result.append("Pipeline Name: ").append(pipelineName == null ? "" : pipelineName).append(System.lineSeparator());
        result.append("Project Name: ").append(projectName == null ? "" : projectName).append(System.lineSeparator());
        result.append("Branch Name: ").append(branchName == null ? "" : branchName).append(System.lineSeparator());
        result.append("Total tests passed: ").append(totalPassedTests).append(System.lineSeparator());
        result.append("Total tests failed: ").append(totalFailedTests).append(System.lineSeparator());
        result.append("Pass percentage: ").append(passPercentage).append(System.lineSeparator());
        result.append("Total run time: ").append((String)totalTime).append(System.lineSeparator());
        result.append(System.lineSeparator());
        result.append(ReportBuilder.getAMaintenanceSuggestion().isPresent() ? ReportBuilder.getAMaintenanceSuggestion().get() : "");
        return result.toString();
    }

    private static Optional<String> getAMaintenanceSuggestion() {
        String mostFailItem = testFailures.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(Functions.identity(), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
        if (null != mostFailItem) {
            long count = testFailures.stream().filter(mostFailItem::equals).count();
            return Optional.of(String.format("You can fix %d test(s) failing with issue '%s'", count, mostFailItem));
        }
        return Optional.of("Hooray! There are no test failures.");
    }

    private static String getTotalFailedTests(String testResultFinalXML) {
        return XMLReader.getValue("testsuite.@failures", testResultFinalXML);
    }

    private static float getTotalRunTime(String testResultFinalXML) {
        float runTime = 0.0f;
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ROOT);
        String timeValue = XMLReader.getValue("testsuite.@time", testResultFinalXML);
        try {
            runTime = numberFormat.parse(timeValue).floatValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return runTime;
    }

    private static int getTotalPassedTests(List<Node> runnerResul) {
        List passedTests = runnerResul.stream().filter(e -> {
            if (e == null) {
                return false;
            }
            Element element = (Element)e;
            return element.getElementsByTagName("failure").getLength() == 0;
        }).collect(Collectors.toList());
        logger.info(String.format("Passed test count is %d", passedTests.size()));
        return passedTests.size();
    }

    private static List<Node> getTestCasesFrom(String testResultFinalXML) {
        return XMLReader.getNodes("testsuite.testcase", testResultFinalXML);
    }

    private static String analyseResult(Node node) {
        StringBuilder result = new StringBuilder();
        String testCase = node.getAttributes().getNamedItem("name").getTextContent().replace(",", "");
        boolean testPassed = ReportBuilder.hasTestPassed(node);
        String status = "pass";
        ReportModel reportModel = new ReportModel();
        if (!testPassed) {
            Node type = node.getFirstChild().getNextSibling().getAttributes().getNamedItem("type");
            Node messageAttribute = node.getFirstChild().getNextSibling().getAttributes().getNamedItem("message");
            String typeContent = type.getTextContent();
            String failureMessage = "Exception unknown. Refer other reports.";
            if (null != messageAttribute) {
                failureMessage = messageAttribute.getTextContent().replace(",", "").replace("\n", "");
            }
            reportModel = reportMatcher.parse(typeContent, failureMessage);
            status = "fail";
        }
        if (reportModel.functionalFailure() != null) {
            testFailures.add(reportModel.functionalFailure());
        }
        if (reportModel.scriptFailure() != null) {
            testFailures.add(reportModel.scriptFailure());
        }
        if (reportModel.generalFailure() != null) {
            testFailures.add(reportModel.generalFailure());
        }
        float runtime = ReportBuilder.getRunTime(node);
        result.append(testCase).append(",").append(status).append(",").append((String)(reportModel.functionalFailure() == null ? "," : reportModel.functionalFailure() + ",")).append((String)(reportModel.scriptFailure() == null ? "," : reportModel.scriptFailure() + ",")).append((String)(reportModel.generalFailure() == null ? "," : reportModel.generalFailure() + ",")).append(runtime);
        result.append(System.lineSeparator());
        return result.toString();
    }

    private static float getRunTime(Node node) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ROOT);
        float runTime = 0.0f;
        try {
            runTime = numberFormat.parse(node.getAttributes().getNamedItem("time").getTextContent()).floatValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return runTime;
    }

    private static boolean hasTestPassed(Node node) {
        Element nodeElement = (Element)node;
        return nodeElement.getElementsByTagName("failure").getLength() == 0;
    }

    static {
        functionalMatcher.setNextMatcher(scriptFailure);
        scriptFailure.setNextMatcher(thrownExceptionFailure);
        thrownExceptionFailure.setNextMatcher(genericFailure);
        reportMatcher = functionalMatcher;
    }
}

