/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.tabsandwindows;

import com.tidal.wave.browser.Driver;
import com.tidal.wave.tabsandwindows.BrowserWindows;
import com.tidal.wave.tabsandwindows.FirstTab;
import com.tidal.wave.tabsandwindows.LastTab;
import com.tidal.wave.tabsandwindows.Tabs;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WindowType;

public class Windows {
    public static final Supplier<BrowserWindows> first = Windows::firstWindow;
    public static final Supplier<BrowserWindows> last = Windows::lastWindow;
    private static final ThreadLocal<ArrayList<String>> windowHandles = new ThreadLocal();
    private static String currentHandle;

    public static void openNewWindow(String url) {
        WebDriver driver = Driver.getDriver();
        driver.switchTo().newWindow(WindowType.WINDOW);
        Tabs.switchToTab(last);
        driver.navigate().to(url);
    }

    private Windows() {
    }

    public static void switchToWindow(int index) {
        if (index == 0) {
            ++index;
        }
        Windows.captureWindowHandles();
        currentHandle = windowHandles.get().get(index - 1);
        Driver.getDriver().switchTo().window(currentHandle);
    }

    public static void switchToWindow(Supplier<BrowserWindows> tabOrder) {
        Windows.captureWindowHandles();
        currentHandle = windowHandles.get().get(tabOrder.get().getIndex(windowHandles.get().size()) - 1);
        Driver.getDriver().switchTo().window(currentHandle);
    }

    public static void closeTab() {
        Driver.getDriver().close();
        Windows.switchToWindow(last);
    }

    public static void closeWindow(Supplier<BrowserWindows> tabOrder) {
        Windows.switchToWindow(tabOrder);
        Driver.getDriver().close();
        Windows.switchToWindow(tabOrder);
    }

    public static void closeWindow(int index) {
        Windows.switchToWindow(index);
        Driver.getDriver().close();
    }

    public static void remove() {
        windowHandles.remove();
    }

    private static void captureWindowHandles() {
        windowHandles.set(new ArrayList(Driver.getDriver().getWindowHandles()));
    }

    private static BrowserWindows firstWindow() {
        return new FirstTab();
    }

    private static BrowserWindows lastWindow() {
        return new LastTab();
    }
}

