/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.verification.conditions;

import com.tidal.wave.command.Executor;
import com.tidal.wave.commands.GetAttribute;
import com.tidal.wave.data.WaitTime;
import com.tidal.wave.data.WaitTimeData;
import com.tidal.wave.exceptions.TestAssertionError;
import com.tidal.wave.supplier.ObjectSupplier;
import com.tidal.wave.verification.conditions.Condition;
import com.tidal.wave.wait.FluentWait;
import java.time.Duration;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;

public class AttributeCondition
extends Condition {
    private final String attributeType;
    private final String value;
    private final Executor executor = (Executor)ObjectSupplier.instanceOf(Executor.class);

    public AttributeCondition(String attributeType, String value) {
        this.attributeType = attributeType;
        this.value = value;
    }

    @Override
    public void verify(boolean isVisible, boolean isMultiple, List<By> locators) {
        String duration = WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME) == null ? WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME) : WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME);
        Duration waitDuration = Duration.ofSeconds(Integer.parseInt(duration));
        new FluentWait<Executor>(this.executor).pollingEvery(Duration.ofMillis(500L)).forDuration(waitDuration).ignoring(StaleElementReferenceException.class).throwing(TestAssertionError.class).withMessage(String.format("Failed to find attribute '%s' with value '%s'", this.attributeType, this.value)).until(e -> e.withMultipleElements(isMultiple).withAttribute(this.attributeType).isVisible(isVisible).usingLocator(locators).invokeCommand(GetAttribute.class).equals(this.value));
    }
}

