/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.verification.conditions;

import com.tidal.wave.command.Executor;
import com.tidal.wave.commands.FindTextData;
import com.tidal.wave.data.WaitTime;
import com.tidal.wave.data.WaitTimeData;
import com.tidal.wave.exceptions.TestAssertionError;
import com.tidal.wave.supplier.ObjectSupplier;
import com.tidal.wave.verification.conditions.Condition;
import com.tidal.wave.wait.FluentWait;
import java.time.Duration;
import java.util.List;
import org.openqa.selenium.By;

public class MatchingCondition
extends Condition {
    private final String value;
    private final Executor executor = (Executor)ObjectSupplier.instanceOf(Executor.class);

    public MatchingCondition(String value) {
        this.value = value;
    }

    @Override
    public void verify(boolean isVisible, boolean isMultiple, List<By> locators) {
        String duration = WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME) == null ? WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME) : WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME);
        Duration waitDuration = Duration.ofSeconds(Integer.parseInt(duration));
        new FluentWait<Executor>(this.executor).pollingEvery(Duration.ofMillis(500L)).forDuration(waitDuration).throwing(TestAssertionError.class).withMessage(String.format("Expected value %s is not matching with actual value %s", this.value, this.executor.isVisible(isVisible).withMultipleElements(isMultiple).usingLocator(locators).invokeCommand(FindTextData.class, "findTextData"))).until(e -> e.withMultipleElements(isMultiple).isVisible(isVisible).usingLocator(locators).invokeCommand(FindTextData.class, "findTextData").toString().contains(this.value));
    }
}

