/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.verification.expectations;

import com.tidal.wave.command.Executor;
import com.tidal.wave.commands.GetAllCssAttributes;
import com.tidal.wave.data.WaitTime;
import com.tidal.wave.data.WaitTimeData;
import com.tidal.wave.exceptions.TimeoutException;
import com.tidal.wave.supplier.ObjectSupplier;
import com.tidal.wave.verification.expectations.Expectation;
import com.tidal.wave.wait.FluentWait;
import java.time.Duration;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;

public class CSSChangeExpectation
extends Expectation {
    private final Executor executor = (Executor)ObjectSupplier.instanceOf(Executor.class);

    @Override
    public void assertion(boolean isVisible, boolean isMultiple, List<By> locators) {
        String duration = WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME) == null ? WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME) : WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME);
        Duration waitDuration = Duration.ofSeconds(Integer.parseInt(duration));
        String cssProperties = this.executor.isVisible(isVisible).withMultipleElements(isMultiple).usingLocator(locators).invokeCommand(GetAllCssAttributes.class, "getAllCssAttributes").toString();
        this.result = new FluentWait<Executor>(this.executor).pollingEvery(Duration.ofMillis(500L)).forDuration(waitDuration).ignoring(TimeoutException.class).ignoring(StaleElementReferenceException.class).withMessage("Expected a change of state of CSS properties but did not happen").until(e -> !e.withMultipleElements(isMultiple).isVisible(isVisible).usingLocator(locators).invokeCommand(GetAllCssAttributes.class, "getAllCssAttributes").toString().equals(cssProperties));
    }

    @Override
    public void orElseFail() {
        super.orElseFail("Expected a change of state of CSS properties but did not happen");
    }
}

