/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.verification.expectations;

import com.tidal.wave.command.Executor;
import com.tidal.wave.commands.IsEnabled;
import com.tidal.wave.commands.IsVisible;
import com.tidal.wave.data.WaitTime;
import com.tidal.wave.data.WaitTimeData;
import com.tidal.wave.exceptions.TimeoutException;
import com.tidal.wave.supplier.ObjectSupplier;
import com.tidal.wave.verification.expectations.Expectation;
import com.tidal.wave.wait.FluentWait;
import java.time.Duration;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;

public class ClickableExpectation
extends Expectation {
    private final Executor executor = (Executor)ObjectSupplier.instanceOf(Executor.class);
    private boolean isVisibleResult;
    private boolean isEnabledResult;
    private By byLocator;

    @Override
    public void assertion(boolean isVisible, boolean isMultiple, List<By> locators) {
        this.byLocator = locators.get(0);
        String duration = WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME) == null ? WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME) : WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME);
        Duration waitDuration = Duration.ofSeconds(Integer.parseInt(duration));
        FluentWait<Executor> newFluentWait = new FluentWait<Executor>(this.executor);
        this.isVisibleResult = newFluentWait.pollingEvery(Duration.ofMillis(500L)).forDuration(waitDuration).ignoring(TimeoutException.class).ignoring(StaleElementReferenceException.class).withMessage(String.format("Expected condition failed : for clickable condition, element %s expected to visible but was not", locators.get(0))).until(e -> (Boolean)e.withMultipleElements(isMultiple).isVisible(isVisible).usingLocator(locators).invokeCommand(IsVisible.class, "isVisible"));
        this.isEnabledResult = newFluentWait.pollingEvery(Duration.ofMillis(500L)).forDuration(waitDuration).ignoring(TimeoutException.class).ignoring(StaleElementReferenceException.class).withMessage(String.format("Expected condition failed : for clickable condition, element %s expected to be enabled but was not", locators.get(0))).until(e -> (Boolean)e.withMultipleElements(isMultiple).isVisible(isVisible).usingLocator(locators).invokeCommand(IsEnabled.class, "isEnabled"));
    }

    @Override
    public void orElseFail() {
        this.result = this.isVisibleResult && this.isEnabledResult;
        super.orElseFail(String.format("Expected condition failed : Element %s expected to be clickable but was not", this.byLocator));
    }
}

