/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.verification.expectations;

import com.tidal.wave.command.Executor;
import com.tidal.wave.commands.GetSize;
import com.tidal.wave.data.WaitTime;
import com.tidal.wave.data.WaitTimeData;
import com.tidal.wave.exceptions.TimeoutException;
import com.tidal.wave.supplier.ObjectSupplier;
import com.tidal.wave.verification.expectations.Expectation;
import com.tidal.wave.wait.FluentWait;
import java.time.Duration;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;

public class ElementNotPresentExpectation
extends Expectation {
    private final Executor executor = (Executor)ObjectSupplier.instanceOf(Executor.class);
    private By byLocator;

    @Override
    public void assertion(boolean isVisible, boolean isMultiple, List<By> locators) {
        this.byLocator = locators.get(0);
        String duration = WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME) == null ? WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME) : WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME);
        Duration waitDuration = Duration.ofSeconds(Integer.parseInt(duration));
        this.result = new FluentWait<Executor>(this.executor).pollingEvery(Duration.ofMillis(500L)).forDuration(waitDuration).ignoring(TimeoutException.class).ignoring(StaleElementReferenceException.class).withMessage(String.format("Expected condition failed : Element %s expected to be not present but one or more was present in the DOM", locators.get(0))).until(e -> (Integer)e.withMultipleElements(isMultiple).isVisible(isVisible).usingLocator(locators).invokeCommand(GetSize.class, "getSize") == 0);
    }

    @Override
    public void orElseFail() {
        super.orElseFail(String.format("Expected condition failed : Element %s expected to be not present but was present", this.byLocator));
    }
}

