/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.verification.expectations;

import com.tidal.wave.exceptions.ExpectationFailure;
import com.tidal.wave.verification.expectations.AttributesChangeExpectation;
import com.tidal.wave.verification.expectations.CSSChangeExpectation;
import com.tidal.wave.verification.expectations.ClickableExpectation;
import com.tidal.wave.verification.expectations.ElementNotPresentExpectation;
import com.tidal.wave.verification.expectations.ElementPresentExpectation;
import com.tidal.wave.verification.expectations.ExactTextExpectation;
import com.tidal.wave.verification.expectations.InteractableExpectation;
import com.tidal.wave.verification.expectations.InvisibleExpectation;
import com.tidal.wave.verification.expectations.MatchingTextExpectation;
import com.tidal.wave.verification.expectations.NewTextValueExpectation;
import com.tidal.wave.verification.expectations.StaleExpectation;
import com.tidal.wave.verification.expectations.StateChangeExpectation;
import com.tidal.wave.verification.expectations.TextNotEmptyExpectation;
import com.tidal.wave.verification.expectations.VisibleExpectation;
import java.util.List;
import java.util.function.Supplier;
import org.openqa.selenium.By;

public abstract class Expectation {
    protected boolean result;
    public static final Supplier<Expectation> toBeStale = Expectation::toBeStale;
    public static final Supplier<Expectation> toBeVisible = Expectation::toBeVisible;
    public static final Supplier<Expectation> toBeInvisible = Expectation::toBeInvisible;
    public static final Supplier<Expectation> toBeInteractable = Expectation::toBeInteractable;
    public static final Supplier<Expectation> toBeClickable = Expectation::toBeClickable;
    public static final Supplier<Expectation> toBePresent = Expectation::toBePresent;
    public static final Supplier<Expectation> toBeNotPresent = Expectation::toBeNotPresent;
    public static final Supplier<Expectation> textNotEmpty = Expectation::textNotEmpty;
    public static final Supplier<Expectation> newTextValue = Expectation::newTextValue;
    public static final Supplier<Expectation> aChangeOfState = Expectation::aChangeOfState;
    public static final Supplier<Expectation> newAttributes = Expectation::newAttributes;

    private static Expectation toBeStale() {
        return new StaleExpectation();
    }

    private static Expectation toBeVisible() {
        return new VisibleExpectation();
    }

    private static Expectation toBeInteractable() {
        return new InteractableExpectation();
    }

    private static Expectation toBeClickable() {
        return new ClickableExpectation();
    }

    private static Expectation toBeInvisible() {
        return new InvisibleExpectation();
    }

    private static Expectation toBePresent() {
        return new ElementPresentExpectation();
    }

    private static Expectation toBeNotPresent() {
        return new ElementNotPresentExpectation();
    }

    private static Expectation textNotEmpty() {
        return new TextNotEmptyExpectation();
    }

    private static Expectation newTextValue() {
        return new NewTextValueExpectation();
    }

    private static Expectation aChangeOfState() {
        return new StateChangeExpectation();
    }

    private static Expectation newAttributes() {
        return new AttributesChangeExpectation();
    }

    private static Expectation newCSSAttributes() {
        return new CSSChangeExpectation();
    }

    public static Expectation exactText(String text) {
        return new ExactTextExpectation(text);
    }

    public static Expectation matchingText(String text) {
        return new MatchingTextExpectation(text);
    }

    public abstract void assertion(boolean var1, boolean var2, List<By> var3);

    public abstract void orElseFail();

    public void orElseFail(String message) {
        if (!this.result) {
            throw new ExpectationFailure(message);
        }
    }
}

