/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.verification.expectations.collections;

import com.tidal.wave.command.Executor;
import com.tidal.wave.commands.GetSize;
import com.tidal.wave.data.WaitTime;
import com.tidal.wave.data.WaitTimeData;
import com.tidal.wave.exceptions.ExpectationFailure;
import com.tidal.wave.exceptions.TimeoutException;
import com.tidal.wave.supplier.ObjectSupplier;
import com.tidal.wave.verification.expectations.collections.Expectations;
import com.tidal.wave.wait.FluentWait;
import java.time.Duration;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;

public class SizeGreaterThan
implements Expectations {
    private static final String GET_SIZE = "getSize";
    private final Executor executor = (Executor)ObjectSupplier.instanceOf(Executor.class);
    private final int size;
    private boolean result;

    public SizeGreaterThan(int size) {
        this.size = size;
    }

    @Override
    public void assertion(boolean isMultiple, List<By> locators) {
        String duration = WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME) == null ? WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME) : WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME);
        Duration waitDuration = Duration.ofSeconds(Integer.parseInt(duration));
        this.result = new FluentWait<Executor>(this.executor).pollingEvery(Duration.ofMillis(500L)).forDuration(waitDuration).ignoring(TimeoutException.class).ignoring(StaleElementReferenceException.class).withMessage(String.format("Expected number of elements is %d but could find [only] %d element[s]", this.size, (int)((Integer)this.executor.isVisible(false).withMultipleElements(isMultiple).usingLocator(locators).invokeCommand(GetSize.class, GET_SIZE)))).until(e -> (Integer)e.usingLocator(locators).withMultipleElements(isMultiple).invokeCommand(GetSize.class, GET_SIZE) > this.size);
    }

    @Override
    public void orElseFail() {
        if (!this.result) {
            throw new ExpectationFailure(String.format("Expected number of elements is %d but could find [only] %d element[s]", this.size, (int)((Integer)this.executor.invokeCommand(GetSize.class, GET_SIZE))));
        }
    }
}

