/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.webelement;

import com.tidal.wave.counter.TimeCounter;
import com.tidal.wave.data.ElementData;
import com.tidal.wave.data.GlobalData;
import com.tidal.wave.data.WaitTime;
import com.tidal.wave.data.WaitTimeData;
import com.tidal.wave.exceptions.ContextException;
import com.tidal.wave.wait.ThreadSleep;
import com.tidal.wave.webelement.FindWebElement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class Element {
    private static final Logger logger = LogManager.getLogger(Element.class);
    private TimeCounter timeCounter;

    public static WebElement element(By byLocator) {
        return Element.element(byLocator, true);
    }

    public static WebElement element(By byLocator, boolean value) {
        return new FindWebElement().webElement(byLocator, value);
    }

    public WebElement getElement(List<By> locatorSet, boolean visibility, boolean isMultiple) {
        WebElement element;
        int duration = Integer.parseInt(WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME) == null ? WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME) : WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME));
        if (this.timeCounter == null) {
            this.timeCounter = new TimeCounter();
        }
        try {
            element = this.getWebElement(locatorSet, visibility, isMultiple);
            if (!this.timeCounter.timeElapsed(Duration.ofSeconds(duration)) && this.movementDetected(element)) {
                logger.info("Element not stable, movement detected, retrying to find the element");
                element = this.getElement(locatorSet, visibility, isMultiple);
            }
            this.timeCounter = null;
        }
        catch (WebDriverException e) {
            logger.error(e.getMessage());
            ThreadSleep.forMilliS(500L);
            if (this.timeCounter.timeElapsed(Duration.ofSeconds(duration))) {
                throw e;
            }
            element = this.getElement(locatorSet, visibility, isMultiple);
        }
        return element;
    }

    private boolean movementDetected(WebElement element) {
        Point one = element.getLocation();
        ThreadSleep.forMilliS(100L);
        Point two = element.getLocation();
        int xCordDiff = one.getX() - two.getX();
        int yCordDiff = one.getY() - two.getY();
        return xCordDiff != 0 || yCordDiff != 0;
    }

    private WebElement getWebElement(List<By> locators, boolean visibility, boolean isMultiple) {
        WebElement element;
        if (locators.size() > 1) {
            element = this.getWebElementFromSet(locators, visibility, isMultiple);
        } else if (isMultiple) {
            element = new FindWebElement().webElements(locators.get(0), Integer.parseInt(GlobalData.getData(ElementData.INDEX)), visibility);
        } else if (locators.size() == 1) {
            element = new FindWebElement().webElement(locators.get(0), visibility);
        } else {
            throw new ContextException("Locator(s) not set. Set locator context with appropriate function");
        }
        return element;
    }

    private WebElement getWebElementFromSet(List<By> locators, boolean visibility, boolean isMultiple) {
        WebElement element = new FindWebElement().webElement(locators.get(0), visibility);
        for (int i = 1; i < locators.size() - 1; ++i) {
            element = element.findElement(locators.get(i));
        }
        element = isMultiple ? (WebElement)element.findElements(locators.get(locators.size() - 1)).get(Integer.parseInt(GlobalData.getData(ElementData.INDEX))) : element.findElement(locators.get(locators.size() - 1));
        return element;
    }

    public List<WebElement> getElements(List<By> locatorSet, boolean visibility) {
        List elements;
        int duration = Integer.parseInt(WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME));
        if (this.timeCounter == null) {
            this.timeCounter = new TimeCounter();
        }
        try {
            if (locatorSet.size() > 1) {
                ArrayList<By> locators = new ArrayList<By>(locatorSet);
                WebElement element = new FindWebElement().webElement((By)locators.get(0), visibility);
                for (int i = 1; i < locators.size() - 1; ++i) {
                    element = element.findElement((By)locators.get(i));
                }
                elements = element.findElements((By)locators.get(locators.size() - 1));
            } else {
                elements = new FindWebElement().webElements(locatorSet.get(0), visibility);
            }
        }
        catch (WebDriverException e) {
            logger.error(e.getMessage());
            ThreadSleep.forMilliS(500L);
            if (this.timeCounter.timeElapsed(Duration.ofSeconds(duration))) {
                throw e;
            }
            elements = this.getElements(locatorSet, visibility);
        }
        this.timeCounter = null;
        return elements;
    }

    public List<WebElement> getElements(List<By> locatorSet) {
        return this.getElements(locatorSet, false);
    }
}

