/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.webelement;

import com.tidal.wave.browser.Driver;
import com.tidal.wave.counter.TimeCounter;
import com.tidal.wave.data.GlobalData;
import com.tidal.wave.data.WaitTime;
import com.tidal.wave.data.WaitTimeData;
import com.tidal.wave.exceptions.IterationStopper;
import com.tidal.wave.loggers.LoggerUtil;
import com.tidal.wave.supplier.ObjectSupplier;
import com.tidal.wave.wait.Activity;
import com.tidal.wave.wait.ActivityWaiter;
import com.tidal.wave.wait.Wait;
import com.tidal.wave.webelement.IframeIterator;
import java.time.Duration;
import java.util.List;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.WebDriverWait;

public class FindWebElement
extends IframeIterator {
    private static final LoggerUtil log = LoggerUtil.getLogger(FindWebElement.class);
    private final ActivityWaiter activityWaiter = (ActivityWaiter)ObjectSupplier.instanceOf(ActivityWaiter.class);
    private WebDriver driver;
    private WebDriverWait wait;
    private WebDriverWait backgroundActivityWait;
    private TimeCounter timeCounter;

    public WebElement webElement(By locator) {
        return this.webElement(locator, true);
    }

    public WebElement webElement(By locator, boolean ensureVisibilityOfElement) {
        this.wait = Wait.getWait();
        this.driver = Driver.getDriver();
        this.backgroundActivityWait = Wait.getBackgroundMaxWait();
        if (this.getBGCheck()) {
            this.waitForPageLoad(this.driver, this.backgroundActivityWait);
        }
        log.elementsLog("Searching for element " + locator);
        this.findFrameOfElement(locator, ensureVisibilityOfElement);
        log.elementsLog("Found Element " + locator);
        return this.foundElement(this.driver, locator);
    }

    public WebElement webElements(By locator, int index, boolean visibility) {
        this.wait = Wait.getWait();
        this.driver = Driver.getDriver();
        this.backgroundActivityWait = Wait.getBackgroundMaxWait();
        if (this.getBGCheck()) {
            this.waitForPageLoad(this.driver, this.backgroundActivityWait);
        }
        log.elementsLog("Searching for " + (index + 1) + " elements with locator " + locator);
        try {
            this.switchToIframeOfElement(locator, visibility);
        }
        catch (IterationStopper iterationStopper) {
            // empty catch block
        }
        try {
            this.wait.until(d -> d.findElements(locator).size() - 1 >= index);
        }
        catch (TimeoutException e) {
            throw new TimeoutException(String.format("Expected %d elements, but found only %d element[s] in %d seconds", index + 1, this.driver.findElements(locator).size(), this.getWaitTime()));
        }
        List elements = (List)this.wait.until(d -> d.findElements(locator));
        if (elements.size() - 1 >= index) {
            return (WebElement)elements.get(index);
        }
        throw new TimeoutException(String.format("Expected %d elements, but found only %d element[s]", index + 1, elements.size()));
    }

    public List<WebElement> webElements(By locator, boolean visibility) {
        this.wait = Wait.getWait();
        this.driver = Driver.getDriver();
        this.backgroundActivityWait = Wait.getBackgroundMaxWait();
        log.elementsLog("Searching for elements " + locator);
        if (this.getBGCheck()) {
            this.waitForPageLoad(this.driver, this.backgroundActivityWait);
        }
        try {
            this.switchToIframeOfElement(locator, visibility);
        }
        catch (IterationStopper iterationStopper) {
            // empty catch block
        }
        List elements = (List)this.wait.until(d -> d.findElements(locator));
        if (!elements.isEmpty()) {
            log.elementsLog("Elements found " + locator + " is [" + elements.size() + "]");
        } else {
            log.elementsLog("No elements found " + locator);
        }
        return elements;
    }

    private void findFrameOfElement(By locator, boolean visibility) {
        Function<WebDriver, Boolean> findElement = d -> {
            if (this.getBGCheck()) {
                this.waitForPageLoad((WebDriver)d, this.backgroundActivityWait);
            }
            try {
                return this.switchToIframeOfElement(locator, visibility);
            }
            catch (IterationStopper ignored) {
                return true;
            }
        };
        try {
            this.wait.until(findElement);
        }
        catch (TimeoutException e) {
            throw new TimeoutException(String.format("Element not found using %s in %d seconds", locator, this.getWaitTime()));
        }
        catch (RuntimeException e) {
            this.wait.until(findElement);
        }
    }

    private void waitForPageLoad(WebDriver driver, WebDriverWait wait) {
        try {
            this.activityWaiter.waitUntilDocReady(driver, wait);
            if (this.getJQueryCheck()) {
                this.activityWaiter.waitUntilJQueryReady(driver, wait);
            }
            if (this.getAngularCheck()) {
                this.activityWaiter.waitUntilAngularReady(driver, wait);
            }
            if (this.getAngular5Check()) {
                this.activityWaiter.waitUntilAngular5Ready(driver, wait);
            }
        }
        catch (Exception e) {
            log.elementsLog("Activity Waiter Exception Occurred");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebElement foundElement(WebDriver driver, By locator) {
        WebElement element = this.contextElement;
        if (this.timeCounter == null) {
            this.timeCounter = new TimeCounter();
        }
        try {
            if (element.isDisplayed()) {
                String jsHighLighter = "arguments[0].style.border='1px dotted green'";
                ((JavascriptExecutor)driver).executeScript(jsHighLighter, new Object[]{element});
                WebElement webElement = element;
                return webElement;
            }
        }
        catch (RuntimeException e) {
            if (this.timeCounter.timeElapsed(Duration.ofSeconds(this.getWaitTime()))) {
                throw new TimeoutException(String.format("Element is not found using %s in %d seconds", locator, this.getWaitTime()));
            }
            this.foundElement(driver, locator);
        }
        finally {
            this.timeCounter = null;
        }
        return element;
    }

    private int getWaitTime() {
        String time = WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME) == null ? WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME) : WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME);
        return Integer.parseInt(time);
    }

    protected boolean getBGCheck() {
        if (GlobalData.getData(Activity.ALL_ACTIVITIES_CHECK.getActivityType()) == null) {
            return true;
        }
        return Boolean.parseBoolean(GlobalData.getData(Activity.ALL_ACTIVITIES_CHECK.getActivityType()));
    }

    protected boolean getJQueryCheck() {
        if (GlobalData.getData(Activity.JQUERY_LOAD_WAITER.getActivityType()) == null) {
            return false;
        }
        return Boolean.parseBoolean(GlobalData.getData(Activity.JQUERY_LOAD_WAITER.getActivityType()));
    }

    protected boolean getAngularCheck() {
        if (GlobalData.getData(Activity.ANGULAR_CHECK.getActivityType()) == null) {
            return false;
        }
        return Boolean.parseBoolean(GlobalData.getData(Activity.ANGULAR_CHECK.getActivityType()));
    }

    protected boolean getAngular5Check() {
        if (GlobalData.getData(Activity.ANGULAR_5_CHECK.getActivityType()) == null) {
            return false;
        }
        return Boolean.parseBoolean(GlobalData.getData(Activity.ANGULAR_CHECK.getActivityType()));
    }
}

