/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.webelement;

import com.tidal.wave.command.Executor;
import com.tidal.wave.commands.FindAllTextData;
import com.tidal.wave.commands.GetSize;
import com.tidal.wave.commands.IsPresent;
import com.tidal.wave.data.ElementData;
import com.tidal.wave.data.GlobalData;
import com.tidal.wave.verification.conditions.TestVerification;
import com.tidal.wave.verification.conditions.collections.CollectionsCondition;
import com.tidal.wave.verification.expectations.CollectionsSoftAssertion;
import com.tidal.wave.verification.expectations.collections.Expectations;
import com.tidal.wave.wait.ThreadSleep;
import com.tidal.wave.wait.Wait;
import com.tidal.wave.webelement.UIActions;
import com.tidal.wave.webelement.UIElement;
import java.util.AbstractList;
import java.util.List;
import org.openqa.selenium.By;

public class UIElements
extends AbstractList<UIElement> {
    private UIActions uiActions;
    private boolean visibility;

    protected UIElements setProperties(By byLocator) {
        this.visibility = false;
        this.uiActions = new UIActions();
        this.uiActions.setProperties(byLocator);
        this.uiActions.setMultiple();
        return this;
    }

    protected void setElementProperties(UIActions uiActions, boolean visibility) {
        this.uiActions = uiActions;
        this.visibility = visibility;
        uiActions.setMultiple();
    }

    protected UIElements withDefaultWait() {
        Wait.setDefaultWait();
        return this;
    }

    public UIElements visibleElements() {
        this.visibility = true;
        return this;
    }

    @Override
    public UIElement get(int index) {
        GlobalData.addData(ElementData.INDEX, String.valueOf(index));
        return this.uiActions;
    }

    public List<String> getAllText() {
        return (List)new Executor().usingLocator(this.uiActions.getLocators()).isVisible(this.visibility).invokeCommand(FindAllTextData.class);
    }

    @Override
    public int size() {
        return (Integer)new Executor().usingLocator(this.uiActions.getLocators()).isVisible(this.visibility).invokeCommand(GetSize.class);
    }

    public boolean isPresent() {
        return (Boolean)new Executor().usingLocator(this.uiActions.getLocators()).isVisible(this.visibility).invokeCommand(IsPresent.class);
    }

    public UIElements pause(int seconds) {
        ThreadSleep.forSeconds(seconds);
        return this;
    }

    public void shouldHave(CollectionsCondition ... condition) {
        TestVerification.verification(this.visibility, true, this.uiActions.getLocators(), condition);
    }

    public Expectations expecting(Expectations expectations) {
        return CollectionsSoftAssertion.softAssert(true, this.uiActions.getLocators(), expectations);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (UIElement e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }
}

