/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.browser;

import com.tidal.wave.browser.BrowserFactory;
import com.tidal.wave.browser.DriverCommand;
import com.tidal.wave.data.Store;
import java.util.Objects;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.AbstractDriverOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Driver {
    private final Logger logger = LoggerFactory.getLogger(Driver.class);
    private DriverCommand driverCommand;

    public DriverCommand create(String browserType, AbstractDriverOptions<?> options) {
        WebDriver webDriver = Driver.getDriver();
        if (null == webDriver) {
            webDriver = new BrowserFactory().getBrowser(browserType, options);
        }
        Store.objectType("Driver", webDriver);
        this.driverCommand = new DriverCommand(webDriver);
        return this.driverCommand;
    }

    public void close() {
        this.logger.info("Quitting Driver");
        Objects.requireNonNull(this.driverCommand, "Attempting to close a browser which was not initiated");
        this.driverCommand.closeDriver();
    }

    public static WebDriver getDriver() {
        return (WebDriver)Store.getTypeObject("Driver");
    }
}

