/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.command;

import com.tidal.wave.command.CommandContext;
import com.tidal.wave.exceptions.MethodInvokerException;
import com.tidal.wave.exceptions.RuntimeTestException;
import com.tidal.wave.stackbuilder.ErrorStack;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public interface Command {
    public void contextSetter(CommandContext var1);

    default public <T> T execute(String action) {
        Object value;
        Class<?> klass = this.getClass();
        try {
            Method method = klass.getDeclaredMethod(action, new Class[0]);
            value = method.invoke((Object)this, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new MethodInvokerException(String.format("No such method with name '%s', in class '%s'", action, klass.getName()), e);
        }
        catch (InvocationTargetException e) {
            String errorDetail = e.getCause().getMessage();
            errorDetail = new ErrorStack().constructedError(errorDetail, Thread.currentThread().getStackTrace());
            throw new RuntimeTestException(String.format("Exception caused from action '%s' %s", action, errorDetail));
        }
        catch (IllegalAccessException e) {
            throw new MethodInvokerException(String.format("Method '%s', in class '%s' has got private/protected access", action, klass.getName()), e);
        }
        return (T)value;
    }
}

