/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.commands;

import com.tidal.wave.command.Command;
import com.tidal.wave.command.CommandAction;
import com.tidal.wave.command.CommandContext;
import com.tidal.wave.command.Commands;
import com.tidal.wave.counter.TimeCounter;
import com.tidal.wave.exceptions.CommandExceptions;
import com.tidal.wave.supplier.ObjectSupplier;
import com.tidal.wave.webelement.Element;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.RemoteWebElement;

public final class DragAndDropByOffset
extends CommandAction
implements Command {
    private final Supplier<Map<Class<? extends Throwable>, Supplier<String>>> ignoredExceptions = this::ignoredEx;
    private final Element webElement = (Element)ObjectSupplier.instanceOf(Element.class);
    private final TimeCounter timeCounter = new TimeCounter();
    private CommandContext context;
    private boolean isMultiple;
    private int[] xyCords;
    private List<By> locators;

    @Override
    public void contextSetter(CommandContext context) {
        this.context = context;
        this.context.setVisibility(false);
        this.locators = context.getLocators();
        this.xyCords = context.getXYCords();
    }

    @Override
    public Map<Class<? extends Throwable>, Supplier<String>> ignoredEx() {
        return CommandExceptions.TypeOf.stale();
    }

    public void dragAndDropByOffsetAction() {
        LinkedList<By> linkedListOne = new LinkedList<By>();
        linkedListOne.add(this.locators.get(0));
        this.context.setLocatorSet(linkedListOne);
        WebElement sourceElement = this.webElement.getElement(this.context);
        new Actions(((RemoteWebElement)sourceElement).getWrappedDriver()).dragAndDropBy(sourceElement, this.xyCords[0], this.xyCords[1]).perform();
    }

    public void dragAndDropByOffset() {
        this.timeCounter.restart();
        super.execute(Commands.MoveCommands.DRAG_AND_DROP_BY_OFFSET.toString(), this.ignoredExceptions, this.timeCounter);
    }
}

