/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.commands;

import com.tidal.wave.command.Command;
import com.tidal.wave.command.CommandAction;
import com.tidal.wave.command.CommandContext;
import com.tidal.wave.command.Commands;
import com.tidal.wave.counter.TimeCounter;
import com.tidal.wave.exceptions.CommandExceptions;
import com.tidal.wave.supplier.ObjectSupplier;
import com.tidal.wave.webelement.Element;
import java.util.Map;
import java.util.function.Supplier;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.RemoteWebElement;

public final class MoveToElement
extends CommandAction
implements Command {
    private final Supplier<Map<Class<? extends Throwable>, Supplier<String>>> ignoredExceptions = this::ignoredEx;
    private final Element webElement = (Element)ObjectSupplier.instanceOf(Element.class);
    private final TimeCounter timeCounter = new TimeCounter();
    private CommandContext context;

    @Override
    public void contextSetter(CommandContext context) {
        this.context = context;
        this.context.setVisibility(false);
    }

    @Override
    public Map<Class<? extends Throwable>, Supplier<String>> ignoredEx() {
        return CommandExceptions.TypeOf.notInteractableAndStale();
    }

    public void moveToElementAction() {
        WebElement element = this.webElement.getElement(this.context);
        new Actions(((RemoteWebElement)element).getWrappedDriver()).moveToElement(element).perform();
    }

    public void moveToElement() {
        this.timeCounter.restart();
        super.execute(Commands.MoveCommands.MOVE_TO_ELEMENT.toString(), this.ignoredExceptions, this.timeCounter);
    }
}

