/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.commands;

import com.tidal.wave.command.Command;
import com.tidal.wave.command.CommandAction;
import com.tidal.wave.command.CommandContext;
import com.tidal.wave.command.Commands;
import com.tidal.wave.counter.TimeCounter;
import com.tidal.wave.exceptions.CommandExceptions;
import com.tidal.wave.supplier.ObjectSupplier;
import com.tidal.wave.webelement.Element;
import java.util.Map;
import java.util.function.Supplier;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public final class SelectByIndex
extends CommandAction
implements Command {
    private final Supplier<Map<Class<? extends Throwable>, Supplier<String>>> ignoredExceptions = this::ignoredEx;
    private final Element webElement = (Element)ObjectSupplier.instanceOf(Element.class);
    private final TimeCounter timeCounter = new TimeCounter();
    private CommandContext context;
    private int selectIndex;

    @Override
    public void contextSetter(CommandContext context) {
        this.context = context;
        this.selectIndex = context.getSelectIndex();
    }

    @Override
    public Map<Class<? extends Throwable>, Supplier<String>> ignoredEx() {
        return CommandExceptions.TypeOf.stale();
    }

    public String selectByIndexAction() {
        WebElement element = this.webElement.getElement(this.context);
        Select select = new Select(element);
        select.selectByIndex(this.selectIndex);
        return select.getFirstSelectedOption().getText();
    }

    public String selectByIndex() {
        this.timeCounter.restart();
        return (String)super.execute(Commands.SelectCommands.SELECT_BY_INDEX.toString(), this.ignoredExceptions, this.timeCounter);
    }
}

