/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.csv;

import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import com.opencsv.exceptions.CsvValidationException;
import com.tidal.wave.exceptions.DataResolverException;
import com.tidal.wave.propertieshandler.PropertiesFinder;
import com.tidal.wave.scenario.ScenarioInfo;
import com.tidal.wave.utils.Helper;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvData {
    private final Logger logger = LoggerFactory.getLogger(CsvData.class);

    public static synchronized void updateDataTo(String dataPoolName, String key, String value) {
        String testCaseName = ScenarioInfo.getScenarioName();
        CsvData.updateDataTo(dataPoolName, key, value, testCaseName);
    }

    public static synchronized void updateDataTo(String dataPoolName, String key, String value, String testCaseName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        CsvData.updateDataTo(dataPoolName, map, testCaseName);
    }

    public static synchronized void updateDataTo(String dataPoolName, Map<String, String> map) {
        String testCaseName = ScenarioInfo.getScenarioName();
        CsvData.updateData(map, dataPoolName, testCaseName);
    }

    public static synchronized void updateDataTo(String dataPoolName, Map<String, String> map, String testCaseName) {
        CsvData.updateData(map, dataPoolName, testCaseName);
    }

    protected static synchronized String readDataFrom(String dataPoolName, String key) {
        String testCaseName = ScenarioInfo.getScenarioName();
        return CsvData.readDataFrom(dataPoolName, key, testCaseName).trim();
    }

    protected static synchronized String readDataFrom(String dataPoolName, String key, String testcaseName) {
        CsvData csvData = new CsvData();
        return csvData.readData(dataPoolName, testcaseName).get(key).trim();
    }

    protected static synchronized LinkedHashMap<String, String> readData(String dataPoolName) {
        String testCaseName = ScenarioInfo.getScenarioName();
        CsvData csvData = new CsvData();
        return csvData.readData(dataPoolName, testCaseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized void updateData(Map<String, String> dataMap, String dataPoolName, String testCaseName) {
        LinkedHashMap<String, String> existingDataMap;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        Map<String, String> newData = dataMap;
        CsvData csvData = new CsvData();
        LinkedHashMap<String, String> newDataMap = existingDataMap = csvData.readData(dataPoolName, testCaseName);
        for (Map.Entry existingDataMapEntry : ((HashMap)existingDataMap).entrySet()) {
            for (Map.Entry<String, String> entry : newData.entrySet()) {
                String newDataMapKey;
                String existingDataMapKey = ((String)existingDataMapEntry.getKey()).trim().replace(" ", "");
                if (!existingDataMapKey.equalsIgnoreCase(newDataMapKey = entry.getKey().trim().replace(" ", ""))) continue;
                newDataMap.put((String)existingDataMapEntry.getKey(), entry.getValue());
            }
        }
        int index = 0;
        String[] values = new String[existingDataMap.size()];
        for (Map.Entry<String, String> entry : ((HashMap)newDataMap).entrySet()) {
            values[index] = entry.getValue();
            ++index;
        }
        try (CSVReader reader = new CSVReader((Reader)new FileReader(CsvData.getDataFilePath() + dataPoolName + ".csv"));){
            CSVWriter cSVWriter;
            Object var12_16 = null;
            try {
                String[] nextLine;
                while ((nextLine = reader.readNext()) != null) {
                    if (nextLine[0].trim().equals(testCaseName)) {
                        arrayList.add(values);
                        continue;
                    }
                    arrayList.add(nextLine);
                }
                cSVWriter = new CSVWriter((Writer)new FileWriter(CsvData.getDataFilePath() + dataPoolName + ".csv"));
                if (null == cSVWriter) return;
            }
            catch (CsvValidationException | IOException e) {
                e.printStackTrace();
                return;
            }
            finally {
                if (null != var12_16) {
                    var12_16.writeAll(arrayList);
                    var12_16.close();
                }
            }
            cSVWriter.writeAll(arrayList);
            cSVWriter.close();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static synchronized String getDataFilePath() {
        String csvFilePath = Helper.getAbsoluteFromRelativePath("src/test/resources/csv");
        String env = PropertiesFinder.getEnvironment();
        String filePath = csvFilePath + "/" + env + "/";
        return filePath;
    }

    protected synchronized LinkedHashMap<String, String> readData(String dataPoolName, String testCaseName) {
        String[] columnHeader = null;
        String[] nextLine = null;
        int lineNumber = 0;
        String[] dataRow = null;
        LinkedHashMap<String, String> hashMap = new LinkedHashMap<String, String>();
        this.logger.info("Reading data from: " + CsvData.getDataFilePath() + dataPoolName + ".csv");
        try (FileReader fileReader = new FileReader(CsvData.getDataFilePath() + dataPoolName + ".csv");){
            try (CSVReader reader = new CSVReader((Reader)fileReader);){
                while ((nextLine = reader.readNext()) != null) {
                    if (lineNumber == 0) {
                        columnHeader = nextLine;
                    }
                    ++lineNumber;
                    if (!nextLine[0].trim().equalsIgnoreCase(testCaseName.trim())) continue;
                    dataRow = nextLine;
                    this.logger.info(String.format("Found data from row %s for test case: '%s'", lineNumber, testCaseName));
                    break;
                }
                if (dataRow == null) {
                    throw new DataResolverException();
                }
                for (int index = 0; index < columnHeader.length; ++index) {
                    hashMap.put(columnHeader[index], dataRow[index].trim());
                }
            }
            catch (Exception e) {
                if (e instanceof DataResolverException) {
                    throw new DataResolverException();
                }
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            if (e instanceof DataResolverException) {
                String message = String.format("The test case '%s' was not found from file '%s.csv'", testCaseName, dataPoolName);
                this.logger.info(message);
            }
            e.printStackTrace();
        }
        return hashMap;
    }

    protected synchronized List<HashMap<String, String>> readDataAsMapList(String dataPoolName, String testCaseName) {
        String[] columnHeader = null;
        String[] nextLine = null;
        int lineNumber = 0;
        String[] dataRow = null;
        ArrayList<HashMap<String, String>> dataCollectionList = new ArrayList<HashMap<String, String>>();
        this.logger.info("Reading data from: " + CsvData.getDataFilePath() + dataPoolName + ".csv");
        try (FileReader fileReader = new FileReader(CsvData.getDataFilePath() + dataPoolName + ".csv");){
            try (CSVReader reader = new CSVReader((Reader)fileReader);){
                while ((nextLine = reader.readNext()) != null) {
                    if (lineNumber == 0) {
                        columnHeader = nextLine;
                    }
                    ++lineNumber;
                    if (!nextLine[0].trim().equalsIgnoreCase(testCaseName.trim())) continue;
                    LinkedHashMap<String, String> hashMap = new LinkedHashMap<String, String>();
                    dataRow = nextLine;
                    this.logger.info(String.format("Found data from row %s for test case %s", lineNumber, testCaseName));
                    for (int index = 0; index < columnHeader.length; ++index) {
                        hashMap.put(columnHeader[index], dataRow[index].trim());
                    }
                    dataCollectionList.add(hashMap);
                }
                if (dataRow == null) {
                    throw new DataResolverException();
                }
            }
            catch (Exception e) {
                if (e instanceof DataResolverException) {
                    throw new DataResolverException();
                }
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            if (e instanceof DataResolverException) {
                String message = String.format("The test case '%s' was not found from file '%s.csv'", testCaseName, dataPoolName);
                this.logger.info(message);
            }
            e.printStackTrace();
        }
        return dataCollectionList;
    }
}

