/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.locator;

import com.tidal.wave.locator.LocatorParser;
import com.tidal.wave.locator.X;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;

public class Parser {
    private Parser() {
    }

    static class TextParser
    extends LocatorParser {
        @Override
        public By parse(String locator) {
            if (locator.startsWith("text:")) {
                locator = locator.replace("text:", "");
                return By.xpath((String)String.format("//*[text()='%s']", locator));
            }
            Pattern pattern = Pattern.compile("[. ]with|contains[ .]");
            Matcher matcher = pattern.matcher(locator);
            if (matcher.find()) {
                return By.xpath((String)X.path(locator));
            }
            return By.xpath((String)String.format("//*[text()='%s']", locator));
        }
    }

    static class ClassParser
    extends LocatorParser {
        @Override
        public By parse(String locator) {
            if (locator.startsWith(".")) {
                return By.className((String)locator.substring(1));
            }
            if (locator.startsWith("class:") || locator.startsWith("className:")) {
                locator = locator.replace("class:", "").replace("className:", "");
                return By.className((String)locator);
            }
            return this.nextLocatorParser.parse(locator);
        }
    }

    static class CSSParser
    extends LocatorParser {
        @Override
        public By parse(String locator) {
            if (locator.startsWith("css:")) {
                return By.cssSelector((String)locator.replace("css:", ""));
            }
            return this.nextLocatorParser.parse(locator);
        }
    }

    static class LinkTextParser
    extends LocatorParser {
        @Override
        public By parse(String locator) {
            if (locator.startsWith("linkText:")) {
                return By.linkText((String)locator.replace("linkText:", ""));
            }
            if (locator.startsWith("partialLinkText:")) {
                return By.partialLinkText((String)locator.replace("partialLinkText:", ""));
            }
            return this.nextLocatorParser.parse(locator);
        }
    }

    static class NameTagNameParser
    extends LocatorParser {
        @Override
        public By parse(String locator) {
            if (locator.startsWith("name:")) {
                return By.name((String)locator.replace("name:", ""));
            }
            if (locator.startsWith("tagName:")) {
                return By.tagName((String)locator.replace("tagName:", ""));
            }
            return this.nextLocatorParser.parse(locator);
        }
    }

    static class XPathParser
    extends LocatorParser {
        @Override
        public By parse(String locator) {
            if (locator.startsWith("//") || locator.startsWith("(//") || locator.startsWith("./")) {
                return By.xpath((String)locator);
            }
            if (locator.startsWith("title:")) {
                locator = locator.replace("title:", "");
                return By.xpath((String)String.format("//*[@title='%s']", locator));
            }
            return this.nextLocatorParser.parse(locator);
        }
    }

    static class IdParser
    extends LocatorParser {
        @Override
        public By parse(String locator) {
            if (locator.startsWith("#")) {
                return By.id((String)locator.substring(1));
            }
            if (locator.startsWith("id:")) {
                return By.id((String)locator.replace("id:", ""));
            }
            return this.nextLocatorParser.parse(locator);
        }
    }
}

