/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.options;

import com.tidal.wave.options.BrowserOptions;
import com.tidal.wave.propertieshandler.Config;
import com.tidal.wave.propertieshandler.PropertiesFinder;
import java.io.File;
import java.util.HashMap;
import org.openqa.selenium.chrome.ChromeOptions;

public final class ChromeBrowserOptions
implements BrowserOptions {
    public ChromeOptions getLocalOptions() {
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{Config.LOCAL_SCREEN_SIZE});
        this.setCommonOptions(options);
        return options;
    }

    public ChromeOptions getRemoteOptions() {
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{Config.REMOTE_SCREEN_SIZE});
        this.setCommonOptions(options);
        options.addArguments(new String[]{"--headless=new"});
        options.addArguments(new String[]{"--no-sandbox"});
        options.addArguments(new String[]{"--disable-dev-shm-usage"});
        return options;
    }

    public void setCommonOptions(ChromeOptions options) {
        options.addArguments(new String[]{"--disable-notifications"});
        options.addArguments(new String[]{"--remote-allow-origins=*"});
        options.setExperimentalOption("excludeSwitches", (Object)new String[]{"enable-automation"});
        HashMap<String, Object> prefs = new HashMap<String, Object>();
        prefs.put("credentials_enable_service", false);
        prefs.put("profile.password_manager_enabled", false);
        String downloadPath = System.getProperty("user.dir") + File.separator + String.join((CharSequence)File.separator, PropertiesFinder.getProperty("path.downloads").split(","));
        System.out.println("Download path is " + downloadPath);
        prefs.put("download.default_directory", downloadPath);
        options.setExperimentalOption("prefs", prefs);
    }
}

